% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_sampling_designer.R
\name{cluster_sampling_designer}
\alias{cluster_sampling_designer}
\title{Create a design for cluster random sampling}
\usage{
cluster_sampling_designer(N_blocks = 1, N_clusters_in_block = 1000,
  N_i_in_cluster = 50, n_clusters_in_block = 100,
  n_i_in_cluster = 10, icc = 0.2)
}
\arguments{
\item{N_blocks}{An integer. Number of blocks (strata). Defaults to 1 for no blocks.}

\item{N_clusters_in_block}{An integer or vector of integers of length \code{N_blocks}. Number of clusters in each block in the population.}

\item{N_i_in_cluster}{An integer or vector of integers of length \code{sum(N_clusters_in_block)}. Number of units per cluster sampled.}

\item{n_clusters_in_block}{An integer. Number of clusters to sample in each block (stratum).}

\item{n_i_in_cluster}{An integer. Number of units to sample in each cluster.}

\item{icc}{A number in [0,1]. Intra-cluster Correlation Coefficient (ICC).}
}
\value{
A stratified cluster sampling design.
}
\description{
Builds a cluster sampling design for an ordinal outcome variable for a population with \code{N_blocks} strata, each with \code{N_clusters_in_block} clusters, each of which contains \code{N_i_in_cluster} units. The sampling strategy involves sampling \code{n_clusters_in_block} clusters in each stratum, and then sampling \code{n_i_in_cluster} units in each cluster. Outcomes within clusters have intra-cluster correlation approximately equal to \code{ICC}.
}
\details{
Key limitations: The design assumes a fixed number of clusters drawn in each stratum and a fixed number of individuals drawn from each cluster.

See \href{https://declaredesign.org/library/articles/cluster_sampling.html}{vignette online}.
}
\examples{
# To make a design using default arguments:
cluster_sampling_design <- cluster_sampling_designer()
# A design with varying block size and varying cluster size
cluster_sampling_design <- cluster_sampling_designer(
  N_blocks = 2, N_clusters_in_block = 6:7, N_i_in_cluster = 3:15, 
  n_clusters_in_block = 5,  n_i_in_cluster = 2)
}
\author{
\href{https://declaredesign.org/}{DeclareDesign Team}
}
\concept{clusters}
\concept{measurement}
\concept{observational}
