#' US Labour dataset
#' @docType data
#' @keywords datasets
#' @name USLABOUR
#' @usage data(USLABOUR)
#' @format A data frame with 654 rows and 4 variables
#' @source U.S.Department of Labor --- Bureau of Labour Statistics FRED
#'
NULL

#' Children under 5 months mortality rate per 1,000 live births
#' @docType data
#' @keywords datasets
#' @name under5.mort
#' @usage data(under5.mort)
#' @format A data frame with 654 rows and 4 variables
#' @source http://mdgs.un.org/unsd/mdg/Data.aspx
#'
NULL

#' Infant mortality rate (0--1 year) per 1,000 live births
#' @docType data
#' @keywords datasets
#' @name inf.mort
#' @usage data(inf.mort)
#' @format A data frame with 654 rows and 4 variables
#' @source http://mdgs.un.org/unsd/mdg/Data.aspx
#'
NULL

#' Children 1 year old immunized against measles, percentage
#' @docType data
#' @keywords datasets
#' @name maesles.imm
#' @usage data(maesles.imm)
#' @format A data frame with 654 rows and 4 variables
#' @source http://mdgs.un.org/unsd/mdg/Data.aspx
#'
NULL

#' Internet view data
#' @docType data
#' @keywords datasets
#' @name internet.users
#' @usage data(internet.users)
#' @format data frame containing 17518 rows and 6 columns --- 17518 working days of the
#' Internet service considered with respect to variables:
#' service, month, day, hour, unique users and page views.
#' @references Kosiorowski, Rydlewski, Snarska (2016), Detecting a Structural Change in Functional Time Series Using Local Wilcoxon Statistic, arXiv: 1604.03776v2
#'
NULL

#' Relation between minimum wage (MW) and unemployment rate (UR) in France.
#'
#' @docType data
#' @keywords datasets
#' @name france
#' @usage data(france)
#' @format data frame containing 17 rows and two column. MW is a minimum wage, and UR is an unemployment rate.
#'
#'
NULL

#' Air pollution in Katowice city by hour.
#'
#' @docType data
#' @keywords datasets
#' @name katowice.airpollution
#' @usage data("katowice.airpollution")
#' @format data frame containing 181 rows (days) and 24 columns. Each column is an air pollination for given hour.
#'
#'
NULL
