% Generated by roxygen2 (4.0.1): do not edit by hand
\name{depth}
\alias{depth}
\title{Depth calculation}
\usage{
depth(u, X, method = "Projection", name = "X", threads = -1, ...)
}
\arguments{
\item{u}{Numerical vector or matrix whose depth is to be calculated. Dimension has to be the same as that of the observations.}

\item{X}{The data as a matrix, data frame or list. If it is a matrix or data frame, then each row is viewed as one multivariate observation. If it is a list, all components must be numerical vectors of equal length (coordinates of observations).}

\item{method}{Character string which determines the depth function. \code{method} can be "Projection" (the default), "Mahalanobis", "Euclidean" or "Tukey". For details see \code{\link{depth}.}}

\item{name}{name for this data set - it will be used on plots.}

\item{threads}{number of threads used in parallel computations. Default value -1 means that all possible cores will be used.}

\item{...}{parameters specific to method - see \code{\link{depthEuclid}}}
}
\description{
Depth calculation
}
\details{
Calculate depth functions.
}
\examples{
require(robustbase)

 ## Calculation of Projection depth
 data(starsCYG, package = "robustbase")
 depth(t(colMeans(starsCYG)), starsCYG)

 #Aslo for matrices
 depth(starsCYG, starsCYG)

 ## Projection depth applied to a large bivariate data set
 x = matrix(rnorm(9999), nc = 3)
 depth(x, x)
}
\author{
Daniel Kosiorowski, Mateusz Bocian, Anna Wegrzynkiewicz and Zygmunt Zawadzki from Cracow University of Economics.
}
\references{
Liu, R.Y., Parelius, J.M. and Singh, K. (1999), Multivariate analysis by data depth: Descriptive statistics, graphics and inference (with discussion),  Ann. Statist.,  27, 783-858.

Mosler K (2013). Depth statistics. In C Becker, R Fried, K S (eds.), Robustness and Complex Data Structures, Festschrift in Honour of Ursula Gather, pp. 17-34. Springer.

Rousseeuw, P.J. and Struyf, A. (1998), Computing location depth and regression depth in higher dimensions,  Stat. Comput.,  8, 193-203.

Zuo, Y. and Serfling, R. (2000), General Notions of Statistical Depth Functions,  Ann. Statist.,  28, no. 2, 461-482.
}
\seealso{
\code{\link{depthContour}} and \code{\link{depthPersp}} for depth graphics.
}
\keyword{depth}
\keyword{function}
\keyword{multivariate}
\keyword{nonparametric}
\keyword{robust}

