/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial;

import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileController;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;

public class RTileController
extends TileController {
    static RTileController contrBing;
    static RTileController contrOsm;

    public RTileController(TileSource tileSource, TileCache tileCache, TileLoaderListener tileLoaderListener) {
        super(tileSource, tileCache, tileLoaderListener);
        this.tileSource = tileSource;
    }

    public static RTileController getInstance(String string) {
        MemoryTileCache memoryTileCache;
        if (contrBing == null) {
            memoryTileCache = new MemoryTileCache();
            contrBing = new RTileController((TileSource)new BingAerialTileSource(), (TileCache)memoryTileCache, new TileLoaderListener(){

                public TileCache getTileCache() {
                    return memoryTileCache;
                }

                public void tileLoadingFinished(Tile tile, boolean bl) {
                }
            });
        }
        if (contrOsm == null) {
            memoryTileCache = new MemoryTileCache();
            contrOsm = new RTileController((TileSource)new OsmTileSource.Mapnik(), (TileCache)memoryTileCache, new TileLoaderListener(){

                public TileCache getTileCache() {
                    return memoryTileCache;
                }

                public void tileLoadingFinished(Tile tile, boolean bl) {
                }
            });
        }
        if ("bing".equals(string)) {
            return contrBing;
        }
        return contrOsm;
    }

    public Tile getTile(int n, int n2, int n3) {
        int n4 = 1 << n3;
        if (n < 0 || n >= n4 || n2 < 0 || n2 >= n4) {
            return null;
        }
        Tile tile = this.tileCache.getTile(this.tileSource, n, n2, n3);
        if (tile == null) {
            tile = new Tile(this.tileSource, n, n2, n3);
            this.tileCache.addTile(tile);
            tile.loadPlaceholderFromCache(this.tileCache);
        }
        if (!tile.isLoaded()) {
            this.tileLoader.createTileLoaderJob(this.tileSource, n, n2, n3).run();
        }
        return tile;
    }

    public int[] getTileValues(double d, double d2, double d3) {
        try {
            int[] nArray = new int[]{};
            Tile tile = this.getTile((int)Math.round(d), (int)Math.round(d2), (int)Math.round(d3));
            return tile.getImage().getRGB(0, 0, 255, 255, null, 0, 255);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static double[] getTileBBox(double d, double d2, double d3) {
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0};
        int n = (int)Math.round(d);
        int n2 = (int)Math.round(d2);
        int n3 = (int)Math.round(d3);
        dArray[0] = OsmMercator.XToLon((int)n, (int)n3);
        dArray[2] = OsmMercator.XToLon((int)(n + 1), (int)n3);
        dArray[1] = OsmMercator.YToLat((int)n2, (int)n3);
        dArray[3] = OsmMercator.YToLat((int)(n2 + 1), (int)n3);
        return dArray;
    }
}

