/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.data;

import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.data.ExDefaultTableModel;
import org.rosuda.deducer.data.RowNamesListModel;

class RDataFrameVariableModel
extends ExDefaultTableModel {
    String rDataName = null;
    private VariableNumberListModel rowNamesModel;
    private final int numExtraColumns = 1;

    public RDataFrameVariableModel() {
    }

    public RDataFrameVariableModel(String string) {
        this.rDataName = string;
    }

    public int getColumnCount() {
        if (this.rDataName != null) {
            return 5;
        }
        return 0;
    }

    public int getRowCount() {
        try {
            if (((REXPLogical)Deducer.eval("!exists('" + this.rDataName + "')")).isTRUE()[0]) {
                return 0;
            }
            if (this.rDataName != null) {
                return Deducer.eval("ncol(" + this.rDataName + ")").asInteger() + 1;
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public Object getValueAt(int n, int n2) {
        try {
            if (n >= this.getRowCount() - 1) {
                return null;
            }
            if (n2 == 0) {
                return Deducer.eval("colnames(" + this.rDataName + ")[" + (n + 1) + "]").asString();
            }
            if (n2 == 1) {
                REXP rEXP = Deducer.eval(this.rDataName + "[," + (n + 1) + "]");
                if (rEXP.isNull()) {
                    return "NULL";
                }
                if (rEXP.isFactor()) {
                    return "Factor";
                }
                if (rEXP.isInteger()) {
                    return "Integer";
                }
                if (rEXP.isString()) {
                    return "String";
                }
                if (rEXP.isLogical()) {
                    return "Logical";
                }
                if (rEXP.isNumeric()) {
                    return "Double";
                }
                return "?";
            }
            if (n2 == 2) {
                REXP rEXP = Deducer.eval(this.rDataName + "[," + (n + 1) + "]");
                if (rEXP.isFactor()) {
                    String[] stringArray = Deducer.eval("levels(" + this.rDataName + "[," + (n + 1) + "])").asStrings();
                    String string = "";
                    for (int i = 0; i < Math.min(stringArray.length, 50); ++i) {
                        string = string.concat("(" + (i + 1) + ") ");
                        string = string.concat(stringArray[i]);
                        string = string.concat("; ");
                    }
                    return string;
                }
                return "";
            }
            return "";
        }
        catch (Exception exception) {
            return "?";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValueAt(Object object, int n, int n2) {
        if (n >= this.getRowCount() - 1) {
            if (n2 != 0) return;
            Deducer.eval(this.rDataName + "[," + (n + 1) + "]<-NA");
            Deducer.eval("colnames(" + this.rDataName + ")[" + (n + 1) + "]<-'" + object.toString().trim() + "'");
            this.refresh();
            this.rowNamesModel.refresh();
            return;
        } else if (n2 == 0) {
            Deducer.eval("colnames(" + this.rDataName + ")[" + (n + 1) + "]<-'" + object.toString().trim() + "'");
            return;
        } else {
            if (n2 != 1) return;
            String string = object.toString().toLowerCase().trim();
            if (string.equals("integer")) {
                Deducer.eval(this.rDataName + "[," + (n + 1) + "]<-as.integer(" + this.rDataName + "[," + (n + 1) + "])");
            }
            if (string.equals("factor")) {
                Deducer.eval(this.rDataName + "[," + (n + 1) + "]<-as.factor(" + this.rDataName + "[," + (n + 1) + "])");
            }
            if (string.equals("double")) {
                Deducer.eval(this.rDataName + "[," + (n + 1) + "]<-as.double(" + this.rDataName + "[," + (n + 1) + "])");
            }
            if (string.equals("logical")) {
                Deducer.eval(this.rDataName + "[," + (n + 1) + "]<-as.logical(" + this.rDataName + "[," + (n + 1) + "])");
            }
            if (!string.equals("string")) return;
            Deducer.eval(this.rDataName + "[," + (n + 1) + "]<-as.character(" + this.rDataName + "[," + (n + 1) + "])");
            return;
        }
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Variable";
        }
        if (n == 1) {
            return "Type";
        }
        if (n == 2) {
            return "Factor Levels";
        }
        return "";
    }

    public void refresh() {
        this.fireTableDataChanged();
    }

    public class VariableNumberListModel
    extends RowNamesListModel {
        VariableNumberListModel() {
            RDataFrameVariableModel.this.rowNamesModel = this;
        }

        public Object getElementAt(int n) {
            return new Integer(n + 1);
        }

        public int getSize() {
            try {
                if (((REXPLogical)Deducer.eval("!exists('" + RDataFrameVariableModel.this.rDataName + "')")).isTRUE()[0]) {
                    return 0;
                }
                return Deducer.eval("ncol(" + RDataFrameVariableModel.this.rDataName + ")").asInteger() + 1;
            }
            catch (REXPMismatchException rEXPMismatchException) {
                return 0;
            }
        }
    }
}

