% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/declare_measurement.R
\name{declare_measurement}
\alias{declare_measurement}
\alias{measurement_handler}
\title{Declare measurement procedure}
\usage{
declare_measurement(..., handler = measurement_handler, label = NULL)

measurement_handler(data, ...)
}
\arguments{
\item{...}{arguments to be captured, and later passed to the handler}

\item{handler}{a tidy-in, tidy-out function}

\item{label}{a string describing the step}

\item{data}{A data.frame.}
}
\value{
A function that returns a data.frame.
}
\description{
This function adds measured data columns that can be functions of unmeasured data columns.
}
\details{
It is also possible to include measured variables in your declare_population call or to add variables using declare_step. However, putting latent variables in declare_population and variables-as-measured in declare_measurement helps communicate which parts of your research design are in M and which parts are in D.
}
\examples{

design <-
  declare_model(N = 6,
                U = rnorm(N),
                potential_outcomes(Y ~ Z + U)) +
  declare_assignment(Z = complete_ra(N)) + 
  declare_measurement(Y = reveal_outcomes(Y ~ Z))

draw_data(design)


design <-
  declare_model(
    N = 6,
    U = rnorm(N),
    potential_outcomes(Y ~ Z1 + Z2 + U, 
                       conditions = list(Z1 = c(0, 1), Z2 = c(0, 1)))) +
  declare_assignment(Z1 = complete_ra(N), 
                     Z2 = block_ra(blocks = Z1),
                     legacy = FALSE) + 
  declare_measurement(Y = reveal_outcomes(Y ~ Z1 + Z2))

draw_data(design)



}
