% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R, R/ListTables.R
\docType{class}
\name{DatabaseConnectorConnection-class}
\alias{DatabaseConnectorConnection-class}
\alias{dbDisconnect,DatabaseConnectorConnection-method}
\alias{show,DatabaseConnectorConnection-method}
\alias{dbGetInfo,DatabaseConnectorConnection-method}
\alias{dbQuoteIdentifier,DatabaseConnectorConnection,character-method}
\alias{dbQuoteString,DatabaseConnectorConnection,character-method}
\alias{dbGetQuery,DatabaseConnectorConnection,character-method}
\alias{dbSendStatement,DatabaseConnectorConnection,character-method}
\alias{dbExecute,DatabaseConnectorConnection,character-method}
\alias{dbListFields,DatabaseConnectorConnection,character-method}
\alias{dbExistsTable,DatabaseConnectorConnection,character-method}
\alias{dbWriteTable,DatabaseConnectorConnection,ANY-method}
\alias{dbAppendTable,DatabaseConnectorConnection,character-method}
\alias{dbCreateTable,DatabaseConnectorConnection-method}
\alias{dbReadTable,DatabaseConnectorConnection,character-method}
\alias{dbRemoveTable,DatabaseConnectorConnection,ANY-method}
\alias{dbListTables,DatabaseConnectorConnection-method}
\title{DatabaseConnectorConnection class.}
\usage{
\S4method{dbDisconnect}{DatabaseConnectorConnection}(conn)

\S4method{show}{DatabaseConnectorConnection}(object)

\S4method{dbGetInfo}{DatabaseConnectorConnection}(dbObj, ...)

\S4method{dbQuoteIdentifier}{DatabaseConnectorConnection,character}(conn, x, ...)

\S4method{dbQuoteString}{DatabaseConnectorConnection,character}(conn, x, ...)

\S4method{dbGetQuery}{DatabaseConnectorConnection,character}(conn, statement, translate = TRUE, ...)

\S4method{dbSendStatement}{DatabaseConnectorConnection,character}(conn, statement, translate = TRUE, ...)

\S4method{dbExecute}{DatabaseConnectorConnection,character}(conn, statement, translate = TRUE, ...)

\S4method{dbListFields}{DatabaseConnectorConnection,character}(conn, name, databaseSchema = NULL, ...)

\S4method{dbExistsTable}{DatabaseConnectorConnection,character}(conn, name, databaseSchema = NULL, ...)

\S4method{dbWriteTable}{DatabaseConnectorConnection,ANY}(
  conn,
  name,
  value,
  databaseSchema = NULL,
  overwrite = FALSE,
  append = FALSE,
  temporary = FALSE,
  oracleTempSchema = NULL,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  ...
)

\S4method{dbAppendTable}{DatabaseConnectorConnection,character}(
  conn,
  name,
  value,
  databaseSchema = NULL,
  temporary = FALSE,
  oracleTempSchema = NULL,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  ...,
  row.names = NULL
)

\S4method{dbCreateTable}{DatabaseConnectorConnection}(
  conn,
  name,
  fields,
  databaseSchema = NULL,
  oracleTempSchema = NULL,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  ...,
  row.names = NULL,
  temporary = FALSE
)

\S4method{dbReadTable}{DatabaseConnectorConnection,character}(
  conn,
  name,
  databaseSchema = NULL,
  oracleTempSchema = NULL,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  ...
)

\S4method{dbRemoveTable}{DatabaseConnectorConnection,ANY}(
  conn,
  name,
  databaseSchema = NULL,
  oracleTempSchema = NULL,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  ...
)

\S4method{dbListTables}{DatabaseConnectorConnection}(conn, databaseSchema = NULL, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{...}{Not used}

\item{databaseSchema}{The name of the database schema. See details for platform-specific details.}

\item{overwrite}{Overwrite an existing table (if exists)?}

\item{append}{Append to existing table?}

\item{temporary}{Should the table created as a temp table?}

\item{oracleTempSchema}{DEPRECATED: use \code{tempEmulationSchema} instead.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support temp tables. To
emulate temp tables, provide a schema with write privileges where temp tables
can be created.}
}
\value{
\code{dbListTables()}
returns a character vector
that enumerates all tables
and views
in the database.
Tables added with \code{\link[DBI:dbWriteTable]{dbWriteTable()}}
are part of the list.
As soon a table is removed from the database,
it is also removed from the list of database tables.

The same applies to temporary tables if supported by the database.

The returned names are suitable for quoting with \code{dbQuoteIdentifier()}.
}
\description{
Returns the unquoted names of remote tables accessible through this
connection.
This should include views and temporary objects, but not all database backends
(in particular \pkg{RMariaDB} and \pkg{RMySQL}) support this.

}
\details{
The \code{databaseSchema} argument is interpreted differently according to the different platforms:
SQL Server and PDW: The databaseSchema schema should specify both the database and the schema, e.g.
'my_database.dbo'. Impala: the databaseSchema should specify the database. Oracle:
The databaseSchema should specify the Oracle 'user'. All other : The databaseSchema should
specify the schema.

The \code{databaseSchema} argument is interpreted differently according to the different platforms:
SQL Server and PDW: The databaseSchema schema should specify both the database and the schema, e.g.
'my_database.dbo'. Impala: the databaseSchema should specify the database. Oracle:
The databaseSchema should specify the Oracle 'user'. All other : The databaseSchema should
specify the schema.

The \code{databaseSchema} argument is interpreted differently according to the different platforms:
SQL Server and PDW: The databaseSchema schema should specify both the database and the schema, e.g.
'my_database.dbo'. Impala: the databaseSchema should specify the database. Oracle:
The databaseSchema should specify the Oracle 'user'. All other : The databaseSchema should
specify the schema.

The \code{databaseSchema} argument is interpreted differently according to the different platforms:
SQL Server and PDW: The databaseSchema schema should specify both the database and the schema, e.g.
'my_database.dbo'. Impala: the databaseSchema should specify the database. Oracle:
The databaseSchema should specify the Oracle 'user'. All other : The databaseSchema should
specify the schema.

The \code{databaseSchema} argument is interpreted differently according to the different platforms:
SQL Server and PDW: The databaseSchema schema should specify both the database and the schema, e.g.
'my_database.dbo'. Impala: the databaseSchema should specify the database. Oracle:
The databaseSchema should specify the Oracle 'user'. All other : The databaseSchema should
specify the schema.

The \code{databaseSchema} argument is interpreted differently according to the different platforms:
SQL Server and PDW: The databaseSchema schema should specify both the database and the schema, e.g.
'my_database.dbo'. Impala: the databaseSchema should specify the database. Oracle:
The databaseSchema should specify the Oracle 'user'. All other : The databaseSchema should
specify the schema.

The \code{databaseSchema} argument is interpreted differently according to the different platforms:
SQL Server and PDW: The databaseSchema schema should specify both the database and the schema, e.g.
'my_database.dbo'. Impala: the databaseSchema should specify the database. Oracle:
The databaseSchema should specify the Oracle 'user'. All other : The databaseSchema should
specify the schema.

The \code{databaseSchema} argument is interpreted differently according to the different platforms:
SQL Server and PDW: The databaseSchema schema should specify both the database and the schema, e.g.
'my_database.dbo'. Impala: the databaseSchema should specify the database. Oracle:
The databaseSchema should specify the Oracle 'user'. All other : The databaseSchema should
specify the schema.
}
\seealso{
Other DBIConnection generics: 
\code{\link[DBI]{DBIConnection-class}},
\code{\link[DBI]{dbAppendTable}()},
\code{\link[DBI]{dbCreateTable}()},
\code{\link[DBI]{dbDataType}()},
\code{\link[DBI]{dbDisconnect}()},
\code{\link[DBI]{dbExecute}()},
\code{\link[DBI]{dbExistsTable}()},
\code{\link[DBI]{dbGetException}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetQuery}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbListFields}()},
\code{\link[DBI]{dbListObjects}()},
\code{\link[DBI]{dbListResults}()},
\code{\link[DBI]{dbReadTable}()},
\code{\link[DBI]{dbRemoveTable}()},
\code{\link[DBI]{dbSendQuery}()},
\code{\link[DBI]{dbSendStatement}()},
\code{\link[DBI]{dbWriteTable}()}
}
\keyword{internal}
