% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema_conf.R
\name{sourcing_metadata}
\alias{sourcing_metadata}
\alias{opt_pull_character}
\alias{opt_pull_numeric}
\alias{opt_pull_integer}
\alias{opt_pull_date}
\alias{opt_pull_logical}
\alias{opt_pull_table}
\title{Specify YAML configuration options while pulling the schema from DB}
\usage{
opt_pull_character(
  values = TRUE,
  max_uniq_to_pull = 10,
  nchar = TRUE,
  na_ratio = TRUE,
  levels_ratio = TRUE,
  ...
)

opt_pull_numeric(
  values = TRUE,
  max_uniq_to_pull = 10,
  range = TRUE,
  precision = TRUE,
  scale = TRUE,
  na_ratio = TRUE,
  levels_ratio = FALSE,
  ...
)

opt_pull_integer(
  values = TRUE,
  max_uniq_to_pull = 10,
  range = TRUE,
  na_ratio = TRUE,
  levels_ratio = FALSE,
  ...
)

opt_pull_date(range = TRUE, na_ratio = TRUE, levels_ratio = FALSE, ...)

opt_pull_logical(na_ratio = TRUE, levels_ratio = FALSE, ...)

opt_pull_table(nrows = "exact", ...)
}
\arguments{
\item{values}{Should column unique values be sourced? If so the ones are stored as
an array withing \code{values} parameter.}

\item{max_uniq_to_pull}{Pull unique values only when the distinct number of them is less than
provided value. The parameter prevents for sourcing large amount of values to configuration file
for example when dealing with ids column.}

\item{nchar}{Should maximum number of characters in column be pulled? Is so stored as
\code{nchar} parameter in configuration YAML file.}

\item{na_ratio}{Should ratio of NA values existing in column be sourced?}

\item{levels_ratio}{Should ratio of unique column values be sourced?}

\item{...}{Other parameters defining column metadata source. Currently unsupported.}

\item{range}{Should column range be sourced? Is so stored as \code{range} parameter in
configuration YAML file.}

\item{precision}{Currently unused.}

\item{scale}{Currently unused.}

\item{nrows}{Should number of original columns be sourced? When 'exact' stored as a \code{nrows}
parameter for each table in YAML configuration file. When 'ratio' stored as a fraction of original columns
(based on all tables) and saved as \code{nrows} configuration parameter. When 'none'
tables rows information will not be saved.}
}
\description{
The set of function allows to configure which data information should be saved
to configuration YAML file when such configuration is sourced directly from
database schema.
}
