% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DUBStepR.R
\name{DUBStepR}
\alias{DUBStepR}
\title{DUBStepR - Obtain a list of feature genes to characterise cell types}
\usage{
DUBStepR(
  input.data,
  min.cells = 0.05 * ncol(input.data),
  species = "human",
  optimise.features = TRUE,
  k = 10,
  num.pcs = 20,
  error = 0
)
}
\arguments{
\item{input.data}{input gene expression matrix (genes x cells)}

\item{min.cells}{minimum number of cells to filter genes out}

\item{species}{species to use for gene filtering: "human" (default), "mouse" and "rat"}

\item{optimise.features}{Determine optimal feature set using density index}

\item{k}{number of nearest neighbours. Default is 10}

\item{num.pcs}{number of principal components to represent sc data. Default is 20}

\item{error}{Acceptable error margin for kNN computation. Default is 0, but is set to 1 for large datasets}
}
\value{
Returns optimal feature set
}
\description{
DUBStepR - Obtain a list of feature genes to characterise cell types
}
\examples{
res <- DUBStepR(input.data = pbmc_norm_small_data)

}
\author{
ranjanb
}
