% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KNN.R
\name{KNN}
\alias{KNN}
\title{This function performs imputation using the K-Nearest Neighbors (KNN) algorithm and calculates various evaluation metrics including RMSE, MMAE, RRE, and Consistency Proportion Index (CPP) using different hierarchical clustering methods. It also records the execution time of the process.}
\usage{
KNN(data0, data.sample, data.copy, mr, km)
}
\arguments{
\item{data0}{The original dataset containing the response variable and features.}

\item{data.sample}{The dataset used for sampling, which may contain missing values.}

\item{data.copy}{A copy of the original dataset, used for comparison or validation.}

\item{mr}{Indices of the rows with missing values that need to be predicted.}

\item{km}{The number of clusters for k-means clustering.}
}
\value{
A list containing:
\item{Xnew}{The imputed dataset.}
\item{RMSE}{The Root Mean Squared Error.}
\item{MMAE}{The Mean Absolute Error.}
\item{RRE}{The Relative Eelative Error.}
\item{CPP1}{The K-means clustering Consistency Proportion Index.}
\item{CPP2}{The Hierarchical Clustering Complete Linkage Consistency Proportion Index.}
\item{CPP3}{The Hierarchical Clustering Single Linkage Consistency Proportion Index.}
\item{CPP4}{The Hierarchical Clustering Average Linkage Consistency Proportion Index.}
\item{CPP5}{The Hierarchical Clustering Centroid linkage Consistency Proportion Index.}
\item{CPP6}{The Hierarchical Clustering Median Linkage Consistency Proportion Index.}
\item{CPP7}{The Hierarchical Clustering Ward's Method Consistency Proportion Index.}
\item{timeKNN}{The KNN algorithm execution time.}
}
\description{
This function performs imputation using the K-Nearest Neighbors (KNN) algorithm and calculates various evaluation metrics including RMSE, MMAE, RRE, and Consistency Proportion Index (CPP) using different hierarchical clustering methods. It also records the execution time of the process.
}
\keyword{KNN}
\keyword{imputation}
