% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_dssbatch.R
\name{write_dssbatch}
\alias{write_dssbatch}
\title{Constructs and writes a DSSAT simulation batch file}
\usage{
write_dssbatch(x, trtno = 1, rp = 1, sq = 0, op = 0, co = 0, file_name = NULL)
}
\arguments{
\item{x}{a tibble/data frame or character vector; if a tibble, it should contain all
required columns of a DSSAT batch file (FILEX, TRTNO, RP, SQ, OP, CO);
if a character vector, it should contain FileX file names}

\item{trtno}{a numeric vector}

\item{rp}{a numeric vector}

\item{sq}{a numeric vector}

\item{op}{a numeric vector}

\item{co}{a numeric vector}

\item{file_name}{an optional character vector of the intended
batch file name}
}
\value{
invisibly returns a character vector containing the
content of a DSSAT batch file
}
\description{
Constructs and writes a DSSAT simulation batch file
}
\examples{

# Create example batch file path
batch_file_path <- paste0(tempdir(),'/DSSBatch.V47')

# Write example batch file
write_dssbatch(x='UFGA0601.BMX', trtno=1:4, file_name = batch_file_path)

# Construct tibble for DSSAT batch file
batch_tbl <- data.frame(FILEX='UFGA0601.BMX',
                    TRTNO=1:4,
                    RP=1,
                    SQ=0,
                    OP=0,
                    CO=0)

# Write example batch file
write_dssbatch(batch_tbl, file_name = batch_file_path)

}
