# Documentation for working on the DSAIRM package and developing new Apps 



## Package structure 

### Main content
* The main R functions, i.e. the menu and the simulation scripts are in the /R folder. They all start with simulate_. The /R folder also has a few helper functions.
* The /inst folder contains several subfolders: 
  * The shiny apps are in the inst/shinyapps/ subfolder (which gets copied to /shinyapps in the deployed package). Each App has an app.R file and Rmd+HTML files containing the documentation.
  * There are a few other folders in the inst/shinyapps/ directory which do not correspond to shiny apps. Those are:
    * Th../../media folder contains figures and a bib file used as part of the documentation (i.e. the Rmd files). Note that this is not part of the CRAN R package for size reasons, but if you fork the project from github it will be included.
    * Th../../media folder contains css styling for the documentation
  * /inst/docsfordevelopers contains this file. It also contains a sub-folder with starter files to allow development of new apps for the package.
  * /inst/simulatorfunctions contains the R code for all simulator functions for easy access and editing by users.
  * /inst/doc contains the vignettes, this folder should not be edited, see below.
  * /inst/extdata contains data used as part of the R package.

### Other folders
* folder /auxilliary contains package related resources, not needed for package build
* folder /docs contains the package website created by the pkgdown package. Rebuild with pkgdown::build_site()
* folder /man contains the documentation for all public functions, automatically generated by roxygen
* folder /tests contains unit tests, done with the testthat package
* folder /vignettes contains the vignette - this is copied to /inst/doc during package building. edits should be done to the file in the /vignettes folder, not the /inst/doc folder.

## Making new Apps

### Building the App
The easiest way is to use the files in the /newappfiles subfolder. Simply replace the templates with your content.
The following steps are required:

* Write the main simulator function.
* Write the Shiny app.R file. 
* Write the documentation as Rmd and turn it into an HTML.

The app will make use of 3 generate_ helper functions which are part of the package. It will also use the provided CSS file. Once you have written your new app, you should be able to run it by itself.

Before you run the app.R file, make sure you source the simulator function and load the package so all functions needed by the app.R file are availabel.

### Contributing your App
The best approach is to contact me by email (ahandel@uga.edu) or through the Github site, tell me that you have a new app and share it with me. I'll test it, we'll probably have a few discussions, and if I think it's suitable, I'll add it to the package. Of course, you will be credited for the app you developed. Also, if you plan to write and contribute new apps, maybe best if you contact me beforehand, I can then help and provide guidance as needed.


## Information for package development

### To work on package through RStudio: 
* Load DSAIRM.Rproj in RStudio. Edit files as needed.
* Optionally, use RStudio tie-in with github to sync project to github (the 'git' tab).

### Dependency packages for development
* roxygen
* devtools
* testthat
* codecov
* rmarkdown for vignette and shiny documentation
* packages needed: see DESCRIPTION file
* Rtools needs to be installed (on Windows)
* All libraries/packages needed by this one should be loaded via the DESCRIPTION file and not in separate R files

### To update R documentation and vignette
* Edit documentation inside R functions. 
* Build documentation with More/Document or devtools::document()
* Edit vignette inside the /vignettes folder.
* To build new vignette, run devtools::build_vignettes()
* To update the pkgdown website, run pkgdown::build_site()
* To spell-check all Rmd documentation files, use these commands:
files = list.files(path = "C:/data/git/DSAIRM/inst/shinyapps/", recursive=TRUE, pattern = "\\.(Rnw|Rmd)$", full.names = TRUE)
spelling::spell_check_files(files)


### To build the package
* "by hand" edit the DESCRIPTION file to make sure it's up to date
* in RStudio, use the functions in the 'build' tab to test and build the package.
* Run clean and rebuild, then build and reload using menu, or devtools::load_all()
* Run the check, fix any errors 

### To-do at release time 
* Re-build documentation, re-build package
* Re-build vignettes with devtools::build_vignettes()
* Run check and make sure no problems occur
* Re-create package site with pkgdown::build_site()
* Sync everything to github
* Check vignette and function references on website, fix errors
* Do a test run of devtools::release()


