% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DRaWR.R
\name{DRaWR}
\alias{DRaWR}
\title{DRaWR}
\usage{
DRaWR(possetfile = "extdata/sample.setlist", unifile = "extdata/sample.uni",
  networkfile = "extdata/sample.edge", outdir = "output_",
  restarts = c(0.7), nfolds = 1, st2keep = 1, undirected = TRUE,
  unweighted = FALSE, normalize = "type", maxiters = 50, thresh = 1e-04,
  property_types = c("allen_brain_atlas", "chip_binding", "gene_ontology",
  "motif_u5", "pfam_domain", "T1", "T2"), writepreds = 0)
}
\arguments{
\item{possetfile}{(string): location of file containing location of gene sets to test.}

\item{unifile}{(string): location of file listing gene universe.}

\item{networkfile}{(string): location of file containing network contents.}

\item{outdir}{(string): prefix of location of file to write performance results (optionally prediction results).}

\item{restarts}{(vector): vector of restart values to test. Default is c(0.7).}

\item{nfolds}{(int): number of folds for cross validation, 1 is no cross-validation. Default is 4.}

\item{st2keep}{(int): number of property nodes to keep in second stage for each property type. Default is 50.}

\item{undirected}{(bool): boolean to make network undirected.}

\item{unweighted}{(bool): boolean to make network unweighted.}

\item{normalize}{(string): "type" or "none". Default is 'type'.}

\item{maxiters}{(int): maximum number of allowable iterations. Default is 50.}

\item{thresh}{(float): threshold for L1 norm convergence. Default is 0.001.}

\item{property_types}{(vector): list of possible property types. Default is c("go_curated_evidence", "go_inferred_evidence", "pfam_domain").}

\item{writepreds}{(boolean): write predictions out to a file. Default is FALSE}
}
\description{
This function runs the DRaWR two stage random walk with restart method.
}
\examples{
DRaWR(possetfile = system.file("extdata", "sample.setlist", package="DRaWR"),
	unifile = system.file("extdata", "sample.uni", package="DRaWR"),
	networkfile = system.file("extdata", "sample.edge", package="DRaWR"),
	outdir = "output_", restarts = c(.7), nfolds = 1, st2keep = 1,
	undirected = TRUE, unweighted = FALSE, normalize = "type", maxiters = 50,
	thresh = 0.0001, property_types = c("T1", "T2"), writepreds = 0)
}
\keyword{random}
\keyword{restart}
\keyword{walk}
\keyword{with}

