% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdr.R
\name{create_helper_vars}
\alias{create_helper_vars}
\title{create_helper_vars helper function}
\usage{
create_helper_vars(mdr, source_db, target_db)
}
\arguments{
\item{mdr}{A data.table object containing the MDR.}

\item{source_db}{A character string. The name of the source database.
This string must be conform with the corresponding config section
in the config.yml-file.}

\item{target_db}{A character string. The name of the target database.
This string must be conform with the corresponding config section
in the config.yml-file.}
}
\value{
A list with results from the analysis of the metadata repository
  (MDR) with the following items:
  \describe{
  \item{keys_source}{A character vector with the different values of the
  'key' field from the MDR for the source data system.}
  \item{keys_target}{A character vector with the different values of the
  'key' field from the MDR for the target data system.}
  \item{dqa_assessment}{A data.table with a subset of the MDR for the
  dataelement entries with the field 'dqa_assessment' = 1.}
  \item{variable_list}{A mapping list from MDR variable names (MDR field
  'designation') to DQA tool internal variable names (MDR field
  'variable_name').}
  \item{pl}{A nested list with items regarding the plausibility checks}
  \describe{
  \item{atemp_vars}{A data.table with a subset of the MDR with dataelements
  that are associated with atemporal plausibility checks.}
  \item{uniq_vars}{A data.table with a subset of the MDR with dataelements
  that are associated with uniqueness plausibility checks.}
  \item{atemp_helper_vars}{A character vector with further dataelements that
  are required to perform the atemporal plausibility checks.}
  \item{atemp_possible}{A boolean to indicate if all dataelements required
  to perform the atemporal plausibility checks are available in the dataset.}
  \item{uniq_helper_vars}{A character vector with further dataelements that
  are required to perform the uniqueness plausibility checks.}
  \item{uniq_possible}{A boolean to indicate if all dataelements required
  to perform the uniqueness plausibility checks are available in the
  dataset.}
  }
  }
}
\description{
Internal function to create necessary variables from the
  meta data repository (MDR).
}
\examples{
utils_path <- system.file(
  "demo_data/utilities/",
  package = "DQAstats"
)
mdr_filename <- "mdr_example_data.csv"
mdr <- read_mdr(
  utils_path = utils_path,
  mdr_filename = mdr_filename
)

source_system_name <- "exampleCSV_source"
target_system_name <- "exampleCSV_target"

create_helper_vars(
  mdr = mdr,
  source_db = source_system_name,
  target_db = target_system_name
)

}
