% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StochasticSRA.R
\name{StochasticSRA}
\alias{StochasticSRA}
\title{Stochastic SRA construction of operating models}
\usage{
StochasticSRA(
  OM,
  CAA,
  Chist,
  Ind = NA,
  ML = NA,
  CAL = NA,
  mulen = NA,
  wts = c(1, 1, 0.5, 0.1, 1),
  Jump_fac = 1,
  nits = 4000,
  burnin = 500,
  thin = 10,
  ESS = 300,
  MLsd = 0.1,
  ploty = T,
  nplot = 6,
  SRAdir = NA
)
}
\arguments{
\item{OM}{An operating model object with M, growth, stock-recruitment and maturity parameters specified.}

\item{CAA}{A matrix nyears (rows) by nages (columns) of catch at age (age 1 to maxage in length)}

\item{Chist}{A vector of historical catch observations (nyears long) going back to unfished conditions}

\item{Ind}{A vector of historical abundance index observations (assumed proportional to SSB)}

\item{ML}{A vector of historical mean length (in catch) observations}

\item{CAL}{A matrix of nyears (row) by n length bins (columns) of catch at length samples}

\item{mulen}{A vector mean length by length bin, a vector the same as the number of columns of CAL}

\item{wts}{A vector of relative weights for the likelihood functions of CAA, Chist, Ind, ML and CAL}

\item{Jump_fac}{A multiplier of the jumping distribution variance to increase acceptance (lower Jump_fac) or decrease acceptance rate (higher Jump_fac)}

\item{nits}{The number of MCMC iterations}

\item{burnin}{The number of initial MCMC iterations to discard}

\item{thin}{The interval over which MCMC samples are extracted for use in graphing / statistics}

\item{ESS}{Effective sample size - the weighting of the catch at age data}

\item{MLsd}{The lognormal sd of the mean length observations}

\item{ploty}{Do you want to see diagnostics plotted?}

\item{nplot}{how many MCMC samples should be plotted in convergence plots?}

\item{SRAdir}{A directory where the SRA diagnostics / fit are stored}
}
\value{
A list with three positions. Position 1 is the filled OM object, position 2 is the custompars data.frame that may be submitted as an argument to runMSE() and position 3 is the matrix of effort histories \verb{[nyears x nsim]} vector of objects of class\code{classy}
}
\description{
Specify an operating model, using catch composition data and a historical catch series. Returns and operating model with depletion (D), selectivity parameters (L5, LFS) and effort trajectory (Effyears, EffLower, EffUpper) filled.
}
\examples{
\dontrun{
setup()
sim<-SRAsim(testOM,patchy=0.8)
CAA<-sim$CAA
Chist<-sim$Chist
testOM<-StochasticSRA(testOM,CAA,Chist,nsim=30,nits=1000)
runMSE(testOM)
}
}
\references{
Walters, C.J., Martell, S.J.D., Korman, J. 2006. A stochastic approach to stock reduction analysis. Can. J. Fish. Aqua. Sci. 63:212-213.
}
\author{
T. Carruthers (Canadian DFO grant)
}
