% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Blow_funcs.R
\name{getBlow}
\alias{getBlow}
\title{Blow parallel optimization function}
\usage{
getBlow(
  x,
  N,
  Asize,
  SSBMSY,
  SSBpR,
  MPA,
  SSB0,
  nareas,
  retA,
  MGThorizon,
  Find,
  Perr,
  M_ageArray,
  hs,
  Mat_age,
  Wt_age,
  R0a,
  V,
  nyears,
  maxage,
  mov,
  Spat_targ,
  SRrel,
  aR,
  bR,
  Bfrac = 0.5,
  maxF,
  ploty = F,
  plusgroup = 0
)
}
\arguments{
\item{x}{position in a vector}

\item{N}{array of numbers at age by sim and area (dims nsim, maxage, nyears, nareas)}

\item{Asize}{matrix of area size (nsim by nareas)}

\item{SSBMSY}{vector nsim long of spawning biomass at MSY}

\item{SSBpR}{matrix nsim by nareas with SSB per recruit}

\item{MPA}{matrix nyears + proyears by nareas of spatial closures}

\item{SSB0}{vector of SSB0 length nsim}

\item{nareas}{numeric. number of areas}

\item{retA}{array of retention nsim x maxage x nyears}

\item{MGThorizon}{vector nsim long of MGT x HZN}

\item{Find}{matrix of fishing mortality rate nsim x nyears}

\item{Perr}{matrix of recruitment devitions nsim x nyears + maxage -1}

\item{M_ageArray}{array of natural mortality rate nsim x maxage x nyears + proyears}

\item{hs}{vector nsim long of steepness values}

\item{Mat_age}{array nsim x nages x nyears+proyears of maturity at age}

\item{Wt_age}{matrix nsim x nages of weight at age}

\item{R0a}{matrix nsim by nareas of unfished recruitment}

\item{V}{array of vulnerability nsim x maxage x nyears}

\item{nyears}{integer: number of historical years}

\item{maxage}{integer: maximum age}

\item{mov}{array of movement nsim x 2 x 2}

\item{Spat_targ}{vector of spatial targetting parameters}

\item{SRrel}{integer representing recruitmetn dynamics type 1: Bev Holt 2: Ricker}

\item{aR}{vector of recruitment parameters}

\item{bR}{vector of recruitment parameters}

\item{Bfrac}{fraction of SSBMSY that is the target}

\item{maxF}{maximum apical fishing mortality}

\item{ploty}{logical: should a plot be produced}

\item{plusgroup}{Integer. Default = 0 = no plus-group. Use 1 to include a plus-group}
}
\description{
Find the current biomass at which it would take HZN mean generation times
to reach Bfrac x SSBMSY biomass level given zero catches
}
\author{
T. Carruthers with modifications by A. Hordyk
}
\keyword{internal}
