% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OM_Plotting.R
\name{plotMPA}
\alias{plotMPA}
\title{Plot the Historical Spatial Closures}
\usage{
plotMPA(OM, sim = NA)
}
\arguments{
\item{OM}{An object of class OM}

\item{sim}{Optional. Simulation number to plot}
}
\description{
Plot the Historical Spatial Closures
}
\examples{
\dontrun{
OM <- new("OM", Albacore, Generic_Fleet, Perfect_Info, Perfect_Imp)

## 50\% of Area 1 was closed 30 years ago 
cl1 <- c(OM@nyears-30, 0.5, 1)
## 80\% of Area 1 was closed 15 years ago
cl2 <- c(OM@nyears-15, 0.2, 1)
## 100\% of Area 1 was closed last year
cl3 <- c(OM@nyears-1, 0, 1)

OM@MPA <- matrix(c(cl1, cl2, cl3), ncol=3, byrow=TRUE)
plotMPA(OM)
}

}
\author{
A. Hordyk
}
