% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSE_Plotting_PMs.R
\name{Cplot}
\alias{Cplot}
\title{Plot the median biomass and yield relative to last historical year}
\usage{
Cplot(MSEobj, MPs = NA, lastYrs = 5, point.size = 2, lab.size = 4,
  axis.title.size = 12, axis.text.size = 10, legend.title.size = 12)
}
\arguments{
\item{MSEobj}{An object of class MSE}

\item{MPs}{Optional vector of MPs to plot}

\item{lastYrs}{Numeric. Last number of years to summarize results.}

\item{point.size}{Size of the points}

\item{lab.size}{Size of labels}

\item{axis.title.size}{Axis title size}

\item{axis.text.size}{Axis text size}

\item{legend.title.size}{Legend title size}
}
\description{
Compare median biomass and yield in first year and last 5 years of
projection
}
\examples{
\dontrun{
MSE <- runMSE()
Cplot(MSE)
}
}
