% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIscBIO-generic-Clustexp.R
\docType{methods}
\name{Clustexp}
\alias{Clustexp}
\alias{Clustexp,DISCBIO-method}
\title{Clustering of single-cell transcriptome data}
\usage{
Clustexp(
  object,
  clustnr = 3,
  bootnr = 50,
  metric = "pearson",
  do.gap = TRUE,
  SE.method = "Tibs2001SEmax",
  SE.factor = 0.25,
  B.gap = 50,
  cln = 0,
  rseed = NULL,
  quiet = FALSE
)

\S4method{Clustexp}{DISCBIO}(
  object,
  clustnr = 3,
  bootnr = 50,
  metric = "pearson",
  do.gap = TRUE,
  SE.method = "Tibs2001SEmax",
  SE.factor = 0.25,
  B.gap = 50,
  cln = 0,
  rseed = NULL,
  quiet = FALSE
)
}
\arguments{
\item{object}{\code{DISCBIO} class object.}

\item{clustnr}{Maximum number of clusters for the derivation of the cluster
number by the saturation of mean within-cluster-dispersion. Default is 20.}

\item{bootnr}{A numeric value of booststrapping runs for \code{clusterboot}.
Default is 50.}

\item{metric}{Is the method to transform the input data to a distance object.
Metric has to be one of the following: ["spearman", "pearson", "kendall",
"euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski"].}

\item{do.gap}{A logical vector that allows generating the number of clusters
based on the gap statistics. Default is TRUE.}

\item{SE.method}{The SE.method determines the first local maximum of the gap
statistics. The SE.method has to be one of the following:["firstSEmax",
"Tibs2001SEmax", "globalSEmax", "firstmax", "globalmax"]. Default is
"Tibs2001SEmax"}

\item{SE.factor}{A numeric value of the fraction of the standard deviation by
which the local maximum is required to differ from the neighboring points
it is compared to. Default is 0.25.}

\item{B.gap}{Number of bootstrap runs for the calculation of the gap
statistics. Default is 50}

\item{cln}{Number of clusters to be used. Default is \code{NULL} and the
cluster number is inferred by the saturation criterion.}

\item{rseed}{Random integer to enforce reproducible clustering results.}

\item{quiet}{if `TRUE`, intermediate output is suppressed}
}
\value{
The DISCBIO-class object input with the cpart slot filled.
}
\description{
This functions performs the initial clustering of the RaceID
  algorithm.
}
\examples{
sc <- DISCBIO(valuesG1msTest) # changes signature of data
sc <- Clustexp(sc, cln=2)
}
