% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_stats.R
\name{combine_stats}
\alias{combine_stats}
\title{Combine aggregated statistics.}
\usage{
combine_stats(summaries, demo = FALSE)
}
\arguments{
\item{summaries}{(data.table) Data table containing all stats you want to
combine as rows. This data.table must contain the columns
`Min`, `Q10`, `Q25`, `Median`, `Mean`, `SD`, `Q75`, `Q90`, `Max`, `N`.
Each row in this data table represents a site as of the example described
above.}

\item{demo}{(boolean, default = FALSE) Do you want to see how the function
works? Then call `combine_stats(summaries = NULL, demo = TRUE)`.}
}
\value{
A one-row data.table containing the calculated, aggregates
  statistics of the input.
}
\description{
This function provides the functionality to combine multiple
  statistics to a single statistical overview. This is e.g. useful if you
  are only allowed to export statistical characteristics from a site but
  not the data itself. So in this case you have e.g. mean, median and N
  from each site but want to say something about the mean, median and N
  over all sites like you had the data of all sites in one big pool and
  would do the statisitcs there.
}
