% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.DIFtree.R
\name{summary.DIFtree}
\alias{summary.DIFtree}
\alias{print.summary.DIFtree}
\title{Summary for fitted Item focussed Trees}
\usage{
\method{summary}{DIFtree}(object, ...)

\method{print}{summary.DIFtree}(x, ...)
}
\arguments{
\item{object}{Object of class \code{\link[DIFtree]{DIFtree}}}

\item{...}{Further arguments passed to or from other methods}

\item{x}{Object of class \code{\link[DIFtree]{summary.DIFtree}}}
}
\value{
Object of class \code{"summary.DIFtree"}. 
An object of class \code{"summary.DIFtree"} is a list containing the following components:

\item{stats}{Useful overview of detected DIF items, responsible variables and executed splits}
\item{nosplits}{Total number of executed splits during the estimation procedure}
}
\description{
The function takes an object of class \code{"DIFtree"} and returns an useful summary 
with an overiew of all executed splits during the estimation procedure.
}
\examples{
data(data_sim_Rasch)
 
Y <- data_sim_Rasch[,1]
X <- data_sim_Rasch[,-1]
 
\dontrun{
 
mod <- DIFtree(Y=Y,X=X,model="Logistic",type="udif",alpha=0.05,nperm=1000,trace=TRUE)
 
summary(mod)
}

}
\references{
Berger, Moritz and Tutz, Gerhard (2016): Detection of Uniform and Non-Uniform Differential Item Functioning 
by Item Focussed Trees, Journal of Educational and Behavioral Statistics 41(6), 559-592.

Bollmann, Stella, Berger, Moritz & Tutz, Gerhard (2018): Item-Focussed Trees for the Detection 
of Differential Item Functioning in Partial Credit Models, Educational and Psychological Measurement 78(5), 781-804.

Tutz, Gerhard and Berger, Moritz (2016): Item focussed Trees for the Identification of Items
in Differential Item Functioning, Psychometrika 81(3), 727-750.
}
\seealso{
\code{\link[DIFtree]{DIFtree}}, \code{\link[DIFtree]{plot.DIFtree}}, \code{\link[DIFtree]{predict.DIFtree}}
}
\author{
Moritz Berger <moritz.berger@imbie.uni-bonn.de> \cr \url{http://www.imbie.uni-bonn.de/personen/dr-moritz-berger/}
}
