% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIFtree.R
\name{DIFtree}
\alias{DIFtree}
\alias{print.DIFtree}
\title{Item focussed Trees for the Identification of Items in Differential Item Functioning}
\usage{
DIFtree(Y, X, model = c("Rasch", "Logistic", "PCM"), type = c("udif", "dif",
  "nudif"), alpha = 0.05, nperm = 1000, trace = FALSE, penalize = FALSE,
  ...)

\method{print}{DIFtree}(x, ...)
}
\arguments{
\item{Y}{Matrix or Data.frame of binary 0/1 or categorical response (rows correspond to persons, columns correspond to items)}

\item{X}{Data.frame of (not scaled) covariates (rows correspond to persons, columns correspond to covariates)}

\item{model}{Type of model to be fitted; can be \code{"Rasch"}, \code{"Logistic"} or \code{"PCM"}.}

\item{type}{Type of DIF to be modelled; one out of \code{"udif"}, \code{"dif"} and \code{"nudif"}. 
For \code{"Rasch"} and \code{"PCM"} only uniform DIF can be modelled and therefore \code{type} will be ignored.}

\item{alpha}{Global significance level for the permutation tests}

\item{nperm}{Number of permutations used for the permutation tests}

\item{trace}{If true, information about the estimation progress is printed}

\item{penalize}{If true, a small ridge penalty is added to ensure existence of model parameters; only for \code{"Rasch"}.}

\item{...}{Further arguments passed to or from other methods}

\item{x}{Object of class \code{"DIFtree"}}
}
\value{
Object of class \code{"DIFtree"}. 
An object of class \code{"DIFtree"} is a list containing the following components:

\item{splits}{Matrix with detailed information about all executed splits during the estimation process}
\item{coefficients}{List of estimated coefficients for items with and without DIF. 
Structure of \code{coefficients} depends on \code{model} and \code{type}.}
\item{pvalues}{P-values of each permutation test during the estimation process}
\item{devs}{Maximal value statistics \eqn{T_j} of the selected variables in each iteration during the estimation process}
\item{crit}{Critical values of each permutation test during the estimation process}
\item{Y}{Response matrix used in the estimation process}
\item{X}{Model matrix used in the estimation process}
\item{persons}{Number of persons} 
\item{items}{Number of items}
}
\description{
A function to estimate item focussed trees for simultaneous selection of items and variables 
that induce DIF (Differential Item Functioning) in dichotomous or polytomous items. DIF detection can be
based on the Rasch Model (dichotomous case), the Logistic Regression Approach (dichotomous case) or the Partial Credit Model (polytomous case).
The basic method of item focussed recursive partitioning in Rasch Models is described in Tutz and Berger (2015).
}
\details{
The methods require 0/1 coded answers on binary items (\code{"Rasch"} and \code{"Logistic"}) or categorical answers on polytomous items (\code{"PCM"}). 
Items with DIF are gradually identified by recursive partitioning.

For \code{"Rasch"} one yields a model with linear predictors 
\deqn{eta_{pi}=theta_p-tr_i(x_p),}
where \eqn{theta_p} correspond to the ability and \eqn{x_p} correspond to the covariate vector of person p. 

For \code{"Logistic"} one yields a model with linear predictors 
\itemize{
\item Uniform DIF, \code{type="udif"}
\deqn{eta_{pi}=S_p beta_i+tr_i(x_p),}
where \eqn{S_p} corresponds to the test score and \eqn{x_p} corresponds to the covariate vector of person p.
\item DIF and Non-Uniform DIF, \code{type="dif", "nudif"}
\deqn{eta_{pi}=tr_i(x_p)+tr_i(S_p,x_p),}
where \eqn{S_p} corresponds to the test score and \eqn{x_p} corresponds to the covariate vector of person p. 
}

For \code{"PCM"} one yields a model with linear predictors 
\deqn{eta_{pir}=theta_p-tr_{ir}(x_p),}
where \eqn{theta_p} correspond to the ability and \eqn{x_p} correspond to the covariate vector of person p.

 

Significance of each split is verified by permutation tests. The result of the permutation tests 
can strongly depend on the number of permutations \code{nperm}.
In the case of pure terminal nodes estimates of the model do not exist. If \code{penalize=TRUE} 
a small ridge penalty is added during estimation to ensure existence of all parameters.
}
\examples{
data(data_sim_Rasch)
data(data_sim_PCM)
 
Y1 <- data_sim_Rasch[,1]
X1 <- data_sim_Rasch[,-1]

Y2 <- data_sim_PCM[,1]
X2 <- data_sim_PCM[,-1]
 
\dontrun{
 
mod1 <- DIFtree(Y=Y1,X=X1,model="Logistic",type="udif",alpha=0.05,nperm=1000,trace=TRUE)
print(mod1)

mod2 <- DIFtree(Y=Y2,X=X2,model="PCM",alpha=0.05,nperm=100,trace=TRUE)
print(mod2)
}

}
\references{
Berger, Moritz and Tutz, Gerhard (2016): Detection of Uniform and Non-Uniform Differential Item Functioning 
by Item Focussed Trees, Journal of Educational and Behavioral Statistics 41(6), 559-592.

Bollmann, Stella, Berger, Moritz & Tutz, Gerhard (2018): Item-Focussed Trees for the Detection 
of Differential Item Functioning in Partial Credit Models, Educational and Psychological Measurement 78(5), 781-804.

Swaminathan, Hariharan and Rogers, H Jane (1990): Detecting differential item functioning 
using logistic regression procedures, Journal of Educational Measurements 27(4), 361-370.

Tutz, Gerhard and Berger, Moritz (2016): Item focussed Trees for the Identification of Items
in Differential Item Functioning, Psychometrika 81(3), 727-750.
}
\seealso{
\code{\link[DIFtree]{plot.DIFtree}}, \code{\link[DIFtree]{predict.DIFtree}}, \code{\link[DIFtree]{summary.DIFtree}}
}
\author{
Moritz Berger <moritz.berger@imbie.uni-bonn.de> \cr \url{http://www.imbie.uni-bonn.de/personen/dr-moritz-berger/}
}
