% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_hP_methods.R
\name{confint.glm_hP}
\alias{confint.glm_hP}
\title{Confidence Intervals for glm_hP Fits}
\usage{
\method{confint}{glm_hP}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{a fitted object of class inheriting from \code{"glm_hP"}.}

\item{parm}{a specification of which parameters are to be given confidence
intervals, either a vector of numbers or a vector of names. If missing, all
parameters are considered.}

\item{level}{the confidence level required.}

\item{...}{additional argument(s) for methods.}
}
\value{
A matrix (or vector) with columns giving lower and upper confidence
  limits for each \code{beta} parameter. These will be labelled as
  (1-level)/2 and 1 - (1-level)/2 in \% (by default 2.5\% and 97.5\%).
}
\description{
Computes confidence intervals for one or more parameters in a \code{"glm_hP"}
object.
}
\examples{
## Estimate the model
Bids$size.sq <- Bids$size ^ 2
fit <- glm.hP(formula.mu = numbids ~ leglrest + rearest + finrest +
         whtknght + bidprem + insthold + size + size.sq + regulatn,
              formula.gamma = numbids ~ 1, data = Bids)

## Compute confidence intervals for parameters
confint(fit)
}
