% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main_Functions.R
\name{DDPGP_Surv}
\alias{DDPGP_Surv}
\title{Posterior survival function estimation using Gibbs MCMC results}
\usage{
DDPGP_Surv(mcmc, new_pat, range, if_plot = 0, quantiles = c(0.025, 0.975),
  color = "green")
}
\arguments{
\item{mcmc}{A list-The MCMC output from mcmc_Gibbs}

\item{new_pat}{A matrix consisting of the covariates of new sample points. Each row represents one sample point. 
It can also be vector consisting of the covariates of a new sample point.}

\item{range}{A vector consisting of the values to be evaluated in the plot for survival estimation.}

\item{if_plot}{A logical variable indicating whether the survival estimation should be plotted. 
1 means estimation should be plotted; 0 means otherwise. Defualt value is 0, i.e. not plotted.}

\item{quantiles}{A two-dimensional vector determining the quantiles for the confidence bounds to be plotted. The 
first value is the lower quantile and the second value is the upper quantile. Default is (0.025,0.975)}

\item{color}{A string determining the color of the plot.}
}
\value{
A list composed of the estimation for the survival across the given range. The Survival_estimation is the 
mean across all iterations, and the Survival_lower_quant and Survival_upper_quant are the survival function estimations for the
specified quantiles.
}
\description{
Posterior survival function estimation using Gibbs MCMC results
}
\examples{
########################################
#Source dependent packages
library(MASS)
library(mc2d)
library(mvnfast)
library(survival)
#Simulate Data using built-in data generation
##
seed=1
set.seed(seed)
Npat=5
data <- simulate_data(Npat)

########################################
#Run MCMC 
########################################
#Inputs for mcmc 
response <- log(data$OS)
covariate <- cbind(scale(data$Age),data$AUC,data$CR)
censor_status <- data$death
mcmc_settings<-NULL
mcmc_settings$nskip<-10
mcmc_settings$nburn<-50
mcmc_settings$ndisplay<-100
mcmc_settings$nsave<-20
mcmc_settings$sigma_jump<-c(0,4,2.5,4,2.6)
###################
#Run MCMC function
mcmc_Gibbs<-mcmc_DDPGP(response,covariate,censor_status,mcmc_settings)
########################################
#Plotting Survival Estimation 
########################################
#Parameters in Plotting Estimation for Functions 
range=seq(2,8,1)
example_AUC <- 5
example_CR <- 1
example_Age <- 1
new_pat<-cbind(example_Age,example_AUC,example_CR)
if_plot=1
###################
#Plot DDP-GP Survival Esimation
b=DDPGP_Surv(mcmc_Gibbs,new_pat,range, if_plot)

}
