% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dd_utils.R
\name{optimizer}
\alias{optimizer}
\title{Carries out optimization (finding a minimum)}
\usage{
optimizer(
  optimmethod = "simplex",
  optimpars = c(1e-04, 1e-04, 1e-06, 1000),
  num_cycles = 1,
  fun,
  trparsopt,
  jitter = 0,
  ...
)
}
\arguments{
\item{optimmethod}{The method to use for optimization, either 'simplex' or
'subplex'}

\item{optimpars}{Parameters of the optimization: relative tolerance in
function arguments, relative tolerance in function value, absolute tolerance
in function arguments, and maximum number of iterations}

\item{num_cycles}{Number of cycles of the optimization. When set to Inf, the
optimization will be repeated until the result is, within the tolerance,
equal to the starting values, with a maximum of 10 cycles.}

\item{fun}{Function to be optimized}

\item{trparsopt}{Initial guess of the parameters to be optimized}

\item{jitter}{Perturbation of an initial parameter value when precisely equal to 0.5;
this is only relevant when subplex is chosen. The default value is 0, so no jitter
is applied. A recommended value when using it is 1E-5.}

\item{...}{Any other arguments of the function to be optimimzed, or settings
of the optimization routine}
}
\value{
\item{out}{ A list containing optimal function arguments
(\code{par}, the optimal function value (\code{fvalues}) and whether the
optimization converged (\code{conv})}.
}
\description{
A wrapper to use several optimization routines, currently only 'simplex' (a
method adopted from Matlab, or 'subplex', from the R package subplex). The
function is called from several packages by the same author.
}
\examples{

cat("No examples")

}
\author{
Rampal S. Etienne
}
\keyword{models}
