\name{pottwhitt.boot}

\alias{pottwhitt.boot}
\alias{pottwhitt.pboot}

\title{Bootstrap replicates of Potthoff-Whittinghill's statistic}


\description{
Generate bootstrap replicates of Potthoff-Whittinghill's statistic (function
\emph{pottwhitt.stat}), by means of function \emph{boot} from the \emph{boot}
library. Notice that these functions should not  be used separately but as
argument \emph{statistic} when calling function \emph{boot}.

\emph{pottwhitt.boot} is used when performing a non-parametric bootstrap.

\emph{pottwhitt.pboot} is used when performing a parametric bootstrap.
}


\usage{
pottwhitt.boot(data, i)
pottwhitt.pboot(...)
}

\arguments{
\item{data}{A dataframe containing the data, as specified in the 
\bold{DCluster}  manual page.}
\item{i}{Permutation generated by the bootstrap procedure}
\item{...}{Additional arguments passed when performing a bootstrap.}
}

\value{
Both functions return the value of the statistic.
}


\seealso{
DCluster, pottwhitt, pottwhitt.stat
}


\examples{
library(spdep)

data(nc.sids)

sids<-data.frame(Observed=nc.sids$SID74)
sids<-cbind(sids, Expected=nc.sids$BIR74*sum(nc.sids$SID74)/sum(nc.sids$BIR74))
sids<-cbind(sids, x=nc.sids$x, y=nc.sids$y)

niter<-100


#Permutation model
pw.boot<-boot(sids, statistic=pottwhitt.boot, R=niter)
plot(pw.boot)#Plot results


#Multinomial model
pw.mboot<-boot(sids, statistic=pottwhitt.pboot, sim="parametric", ran.gen=multinom.sim,  R=niter)
plot(pw.mboot)#Plot results

#Poisson model
pw.pboot<-boot(sids, statistic=pottwhitt.pboot, sim="parametric", ran.gen=poisson.sim,  R=niter)
plot(pw.pboot)#Plot results

#Poisson-Gamma model
pw.pgboot<-boot(sids, statistic=pottwhitt.pboot, sim="parametric", ran.gen=negbin.sim, R=niter)
plot(pw.pgboot)#Plot results

}

\references{
Potthoff, R. F. and Whittinghill, M.(1966). Testing for Homogeneity: I. The Binomial and Multinomial Distributions. Biometrika 53, 167-182.

Potthoff, R. F. and Whittinghill, M.(1966). Testing for Homogeneity: The Poisson Distribution. Biometrika 53, 183-190.
}

\keyword{htest}
