% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DArand.R
\name{DArand}
\alias{DArand}
\title{Do Differential Analysis with Random Reference Genes}
\usage{
DArand(
  X,
  n1,
  k = NULL,
  alpha = 0.05,
  eta = 0.05,
  beta = 0.1,
  r = 1000,
  with.info = FALSE,
  clog = 1,
  use.multi.core = TRUE,
  step = 0,
  scales = NULL,
  use.Iter = TRUE
)
}
\arguments{
\item{X}{a two-dimensional array (or data.frame) containing the expression table of n individuals in rows and m gene expressions in columns.}

\item{n1}{integer, number of individuals of the first category, should be smaller than n}

\item{k}{integer, number of random genes selected (default \code{k = ceiling(log2(m))}) as reference genes.}

\item{alpha}{numeric, global test level (default 0.05)}

\item{eta}{numeric, inner test level (default 0.05)}

\item{beta}{numeric, inner type II error (default 0.1)}

\item{r}{integer, number of random 'reference' set selected (the default 1000)}

\item{with.info}{logical, if \code{TRUE} results are displayed (the default \code{FALSE})}

\item{clog}{numeric, constant (default 1) controlling the gaussian approximation of the test statistic (in Negative Binomial and Poisson case) .}

\item{use.multi.core}{logical, if \code{TRUE} (the default) parallel computing with \code{mclapply} is used.}

\item{step}{integer, only used when use.Iter is TRUE to get information on the number of iterations (default 0). Not for use.}

\item{scales}{numeric, only used for simulation of oracle purpose (default \code{NULL}). Not for use.}

\item{use.Iter}{logical, applies iterative procedure  (default FALSE)}
}
\value{
position vector of the gene expressions found as differentially expressed.
}
\description{
Implement the \code{DArand} procedure for transcriptomic data.
The procedure is based on random and repeated selection of subsets of reference genes as described in the paper cited below. Observed counts data are normalized with counts from the subset and a differential analysis is used to detect differentially expressed genes. Thought repetitions, the number times a gene is detected is recorded and the final selection is determined from p-values computed under Binomial distribution and adjusted with the Holm's correction.
}
\details{
The expression table should be organized in such a way that individuals are represented in rows and genes in columns of the \code{X} array. Furthermore, in the current version, the procedure provides a differential analysis comparing exactly two experimental conditions. Hence, lines from 1 to \code{n1} should correspond to the first condition and the remaining lines to the second condition.

In the inner part of the procedure, called further \emph{randomization}, scaling factors are estimated using a normalization subset of \code{k} genes randomly selected from  all m genes.  These \code{k} genes are used as reference genes.  The normalized data are compared between the experimental conditions within an approximately gaussian test for Poisson  or negative-binomial counts as proposed in the methodology cited below. For this inner test the type I (\code{eta}) and the type II (\code{beta}) errors should be specified, otherwise the default values will be used.  Since true reference genes (\emph{housekeeping genes}) are unknown, the inner part is repeated \code{r} times.

Through all \code{r} randomization, for each gene, the number of detections (\emph{i.e.} the number of randomizations when a given gene is identified as differentially expressed) is collected. For these detection counts, the corresponding p-values are computed under the Binomial distribution. The finale detection uses the p-values and,  owing to Holm's correction, controls FWER at specified level \code{alpha}.

The maximal number of discoveries is limited to Delta -  the parameter that is a function of \code{eta}, \code{beta} and the probability of selecting a subset containing at least one differentially expressed gene leading to a wrong normalization (see \code{\link{select_prob}} ) . If \code{use.Iter} is TRUE (the default), the maximal number of discoveries is limited (per iteration) to Delta. The procedure is iterated as long as the number of discoveries is equal to the value of Delta computed in the iteration. Starting from step=1, at each iteration the one-type error is  halved \code{alpha=alpha/2} to ensure the overall test level respects the initial alpha.

\code{clog} is a constant that controls gaussian approximation of the test statistic for the count data arising from Negative Binomial or Poisson distribution. The constant should be ajusted to keep the probability \code{1-5*n^(-clog)} high while shift term \code{1+sqrt(clog*n)} low.
}
\examples{

L = build_example(m=500,m1=25,n1=6,fold=20,mu0=100,use.scales=FALSE,nb.size=Inf)
DArand(L$X,L$n1,alpha=0.05)

}
\references{
\emph{Differential analysis in Transcriptomic: The strengh of randomly picking 'reference' genes}, D. Desaulle, C. Hoffman, B. Hainque and Y. Rozenholc.
\url{https://arxiv.org/abs/2103.09872}
}
\author{
D. Desaulle and Y. Rozenholc
}
