% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_DAP_C.R
\name{solve_DAP_C}
\alias{solve_DAP_C}
\title{Solves DAP optimization problem for a given lambda value}
\usage{
solve_DAP_C(X1, X2, lambda, Vinit = NULL, eps = 1e-04, maxiter = 10000)
}
\arguments{
\item{X1}{A n1 x p matrix of group 1 data
(scaled).}

\item{X2}{A n2 x p matrix of group 2 data
(scaled).}

\item{lambda}{A value of the tuning parameter lambda.}

\item{Vinit}{Optional starting point, the default is NULL, and the algorithm starts with the matrix of zeros.}

\item{eps}{Convergence threshold for the block-coordinate decent algorithm based on the maximum element-wise change in \eqn{V}. The default is 1e-4.}

\item{maxiter}{Maximum number of iterations, the default is 10000.}
}
\value{
A list of
       \item{V}{A p x 2 projection matrix to be used in DAP classification algorithm.}
       \item{nfeature}{Number of nonzero features.}
       \item{iter}{Number of iterations until convergence.}
}
\description{
Uses block-coordinate descent algorithm to solve DAP problem.
}
\section{Warnings}{

Please use scaled \code{X1} and \code{X2} for this function, they can be obtained using \code{standardizeData} to do so.
}

\examples{
## This is an example for solve_DAP_C

## Generate data
n_train = 50
n_test = 50
p = 100
mu1 = rep(0, p)
mu2 = rep(3, p)
Sigma1 = diag(p)
Sigma2 = 0.5* diag(p)

## Build training data
x1 = MASS::mvrnorm(n = n_train, mu = mu1, Sigma = Sigma1)
x2 = MASS::mvrnorm(n = n_train, mu = mu2, Sigma = Sigma2)
xtrain = rbind(x1, x2)
ytrain = c(rep(1, n_train), rep(2, n_train))

## Standardize the data
out_s = standardizeData(xtrain, ytrain, center = FALSE)

## Apply solve_DAP_C
out = solve_DAP_C(X1 = out_s$X1, X2 = out_s$X2, lambda = 0.3)
}
