% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.overall_comparison.R
\name{plot.overall_comparison}
\alias{plot.overall_comparison}
\title{Plot function for overall_comparison}
\usage{
\method{plot}{overall_comparison}(x, ...)
}
\arguments{
\item{x}{- data created with \code{\link{overall_comparison}}}

\item{...}{- other parameters}
}
\value{
A named list of ggplot objects.

It consists of:
\itemize{
\item \code{radar_plot} plot created with \code{\link[auditor]{plot_radar}}
\item \code{accordance_plot} accordance plot of responses. OX axis stand for champion response, while OY for one of challengers
                             responses. Colour indicates on challenger.
}
}
\description{
The function plots data created with \code{\link{overall_comparison}}. For radar plot it uses auditor's
\code{\link[auditor]{plot_radar}}. Keep in mind that the function creates two plots returned as list.
}
\examples{
\donttest{
library("DALEXtra")
library("mlr")
task <- mlr::makeRegrTask(
  id = "R",
  data = apartments,
  target = "m2.price"
)
learner_lm <- mlr::makeLearner(
  "regr.lm"
)
model_lm <- mlr::train(learner_lm, task)
explainer_lm <- explain_mlr(model_lm, apartmentsTest, apartmentsTest$m2.price, label = "LM")

learner_rf <- mlr::makeLearner(
  "regr.randomForest"
)
model_rf <- mlr::train(learner_rf, task)
explainer_rf <- explain_mlr(model_rf, apartmentsTest, apartmentsTest$m2.price, label = "RF")

learner_gbm <- mlr::makeLearner(
  "regr.gbm"
)
model_gbm<- mlr::train(learner_gbm, task)
explainer_gbm <- explain_mlr(model_gbm, apartmentsTest, apartmentsTest$m2.price, label = "GBM")

data <- overall_comparison(explainer_lm, list(explainer_gbm, explainer_rf), type = "regression")
plot(data)
}
}
