% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update_label}
\alias{update_label}
\title{Update label of explainer object}
\usage{
update_label(explainer, label, verbose = TRUE)
}
\arguments{
\item{explainer}{- explainer object that is supposed to be updated.}

\item{label}{- new label, is going to be passed to an explainer}

\item{verbose}{- logical, indicates if information about update should be printed}
}
\value{
updated explainer object
}
\description{
Function allows users to update label of any explainer in a unified way. It doesn't require knowledge about structre of an explainer.
}
\examples{
aps_lm_model4 <- lm(m2.price ~., data = apartments)
aps_lm_explainer4 <- explain(aps_lm_model4, data = apartments, label = "model_4v")
explainer <- update_label(aps_lm_explainer4, label = "lm")
}
