% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_variable.R
\name{variable_response}
\alias{variable_response}
\alias{single_variable}
\title{Marginal Response for a Single Variable}
\usage{
variable_response(explainer, variable, type = "pdp", trans = explainer$link,
  ...)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the 'explain' function}

\item{variable}{character - name of a single variable}

\item{type}{character - type of the response to be calculated.
Currently following options are implemented: 'pdp' for Partial Dependency and 'ale' for Accumulated Local Effects}

\item{trans}{function - a transformation/link function that shall be applied to raw model predictions. This will be inherited from the explainer.}

\item{...}{other parameters}
}
\value{
An object of the class 'svariable_response_explainer'.
It's a data frame with calculated average response.
}
\description{
Calculates the average model response as a function of a single selected variable.
Use the 'type' parameter to select the type of marginal response to be calculated.
Currently for numeric variables we have Partial Dependency and Accumulated Local Effects implemented.
Current implementation uses the 'pdp' package (Brandon M. Greenwell (2017).
pdp: An R Package for Constructing Partial Dependence Plots. The R Journal, 9(1), 421--436.)
and 'ALEPlot' (Dan Apley (2017). ALEPlot: Accumulated Local Effects Plots and Partial Dependence Plots.)
}
\details{
For factor variables we are using the 'factorMerger' package.
Please note that the argument \code{type} must be set to \code{'factor'} to use this method.
}
\examples{
library("breakDown")
logit <- function(x) exp(x)/(1+exp(x))

HR_glm_model <- glm(left~., data = breakDown::HR_data, family = "binomial")
explainer_glm <- explain(HR_glm_model, data = HR_data, trans=logit)
expl_glm <- variable_response(explainer_glm, "satisfaction_level", "pdp")
expl_glm

 \dontrun{
library("randomForest")
HR_rf_model <- randomForest(factor(left)~., data = breakDown::HR_data, ntree = 100)
explainer_rf  <- explain(HR_rf_model, data = HR_data,
                       predict_function = function(model, x)
                              predict(model, x, type = "prob")[,2])
expl_rf  <- variable_response(explainer_rf, variable = "satisfaction_level", type = "pdp",
                       which.class = 2, prob = TRUE)
expl_rf
plot(expl_rf)
 }

}
