% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_sim_core_1_4.R
\name{DAISIE_calc_clade_ana_rate}
\alias{DAISIE_calc_clade_ana_rate}
\title{Calculate the clade-wide effective anagenesis rate.
With 'effective', this means that if an immigrant
undergoes anagenesis, it will become a new species.
Would such a species undergo anagenesis again, no net new
species is created; the species only gets renamed}
\usage{
DAISIE_calc_clade_ana_rate(ps_ana_rate, n_immigrants)
}
\arguments{
\item{ps_ana_rate}{per species anagensis rate}

\item{n_immigrants}{number of immigrants in that clade}
}
\value{
the clade's effective anagenesis rate
}
\description{
Calculate the clade-wide effective anagenesis rate.
With 'effective', this means that if an immigrant
undergoes anagenesis, it will become a new species.
Would such a species undergo anagenesis again, no net new
species is created; the species only gets renamed
}
\examples{
  testit::assert(
    DAISIE:::DAISIE_calc_clade_ana_rate(
      ps_ana_rate = 0.3,
      n_immigrants = 5
    ) == 1.5
  )
}
\author{
Richel J.C. Bilderbeek
}
\keyword{internal}
