% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiments.R
\name{experiments}
\alias{experiments}
\alias{experiments.clone_full,UserSession-method}
\alias{experiments.clone_full}
\alias{experiments.clone_selective,UserSession-method}
\alias{experiments.clone_selective}
\alias{experiments.delete,UserSession-method}
\alias{experiments.delete}
\alias{experiments.full_access_users_list,UserSession-method}
\alias{experiments.full_access_users_list}
\alias{experiments.full_access_users_add,UserSession-method}
\alias{experiments.full_access_users_add}
\alias{experiments.full_access_users_remove,UserSession-method}
\alias{experiments.full_access_users_remove}
\alias{experiments.list,UserSession-method}
\alias{experiments.list}
\alias{experiments.new,UserSession-method}
\alias{experiments.new}
\alias{experiments.show,UserSession-method}
\alias{experiments.show}
\alias{experiments.trash,UserSession-method}
\alias{experiments.trash}
\alias{experiments.update,UserSession-method}
\alias{experiments.update}
\title{Experiment Endpoints}
\usage{
\S4method{experiments.clone_full}{UserSession}(
  UserSession,
  experiment_id,
  output = "default",
  timeout = UserSession@long_timeout
)

\S4method{experiments.clone_selective}{UserSession}(
  UserSession,
  experiment_id,
  experiment_name,
  fcs_files = c(-1),
  primary_researcher = NA,
  principal_investigator = NA,
  clone_gates = FALSE,
  clone_annotations = FALSE,
  clone_attachments = FALSE,
  clone_reagents = FALSE,
  clone_compensations = FALSE,
  clone_panels = FALSE,
  clone_illustrations = FALSE,
  clone_project = FALSE,
  clone_user_access = FALSE,
  allow_full_access_pi = FALSE,
  output = "default",
  timeout = UserSession@long_timeout
)

\S4method{experiments.delete}{UserSession}(
  UserSession,
  experiment_id,
  timeout = UserSession@short_timeout
)

\S4method{experiments.full_access_users_list}{UserSession}(
  UserSession,
  experiment_id,
  output = "default",
  timeout = UserSession@short_timeout
)

\S4method{experiments.full_access_users_add}{UserSession}(
  UserSession,
  experiment_id,
  user_id = NA,
  user_email = NA,
  username = NA,
  timeout = UserSession@short_timeout
)

\S4method{experiments.full_access_users_remove}{UserSession}(
  UserSession,
  experiment_id,
  user_id = NA,
  user_email = NA,
  username = NA,
  timeout = UserSession@short_timeout
)

\S4method{experiments.list}{UserSession}(
  UserSession,
  output = "default",
  timeout = UserSession@short_timeout
)

\S4method{experiments.new}{UserSession}(
  UserSession,
  experiment_name,
  purpose,
  comments = NA,
  primary_researcher = NA,
  principal_investigator = NA,
  output = "default",
  timeout = UserSession@short_timeout
)

\S4method{experiments.show}{UserSession}(
  UserSession,
  experiment_id,
  output = "default",
  timeout = UserSession@short_timeout
)

\S4method{experiments.trash}{UserSession}(
  UserSession,
  experiment_id,
  output = "default",
  timeout = UserSession@short_timeout
)

\S4method{experiments.update}{UserSession}(
  UserSession,
  experiment,
  output = "default",
  timeout = UserSession@short_timeout
)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{experiment_id}{integer representing an experiment ID}

\item{output}{character representing the output format \strong{[optional]}\cr
\emph{- experiments.clone_full, experiments.clone_selective, experiments.full_access_users_list, experiments.list, experiments.new, experiments.show, experiments.trash, experiments.update : \code{("default", "raw")}}}

\item{timeout}{integer representing the request timeout time in seconds \strong{[optional]}}

\item{experiment_name}{character representing an experiment name}

\item{fcs_files}{vector/list of integers representing a list of \link[=fcs_files]{FCS file} IDs \strong{[optional]}}

\item{primary_researcher}{integer representing a primary researcher ID \strong{[optional]}}

\item{principal_investigator}{integer representing a principal investigator ID \strong{[optional]}}

\item{clone_gates}{boolean denoting cloning gates option \strong{[optional]}}

\item{clone_annotations}{boolean denoting cloning annotations option \strong{[optional]}}

\item{clone_attachments}{boolean denoting cloning attachments option \strong{[optional]}}

\item{clone_reagents}{boolean denoting cloning reagents option \strong{[optional]}}

\item{clone_compensations}{boolean denoting cloning compensations option \strong{[optional]}}

\item{clone_panels}{boolean denoting cloning panels option \strong{[optional]}}

\item{clone_illustrations}{boolean denoting cloning illustrations option \strong{[optional]}}

\item{clone_project}{boolean denoting cloning project option \strong{[optional]}}

\item{clone_user_access}{boolean denoting cloning user access option \strong{[optional]}}

\item{allow_full_access_pi}{boolean denoting to allow full access to PI option \strong{[optional]}}

\item{user_id}{integer representing a user's ID}

\item{user_email}{character representing a user's email}

\item{username}{character representing a username}

\item{purpose}{character representing an experiment purpose}

\item{comments}{character representing an experiment comment \strong{[optional]}}

\item{experiment}{dataframe representing an experiment}
}
\description{
Interact with experiment endpoints. An Experiment is a container for data and analyses in Cytobank. If data are on Cytobank, they must be within an Experiment. Configurations such as \link{gates}, \link{compensations}, \link{scales}, Sample Tags, and illustrations are also linked to an individual Experiment. Within the Cytobank interface, the \href{https://support.cytobank.org/hc/en-us/articles/206946617-The-Experiment-Summary-page}{Experiment Summary Page} is a useful integration point for information about an Experiment.
}
\details{
\code{experiments.clone_full} Full clone an experiment. \href{https://support.cytobank.org/hc/en-us/articles/205337847-Clone-an-experiment-to-make-a-copy-for-your-own-use#full_clone}{Learn more about the full clone functionality}.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{experiments.clone_selective} Selectively clone an experiment. \href{https://support.cytobank.org/hc/en-us/articles/205337847-Clone-an-experiment-to-make-a-copy-for-your-own-use#selective_clone}{Learn more about the selective clone functionality}\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{experiments.delete} Permanently delete an experiment and all analyses (including SPADE, viSNE, etc.) permanently. This is not reversible.

\code{experiments.list} List all full access users from an experiment.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{experiments.list} Add a full access user to an experiment. A full access user can be added by a user ID, email, or username.

\code{experiments.list} Remove a full access user from an experiment. A full access user can be removed by a user ID, email, or username.

\code{experiments.list} List all inbox experiments. Outputs a dataframe [default] or raw list with all fields present.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{experiments.new} Create a new experiment.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{experiments.show} Show experiment details.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{experiments.trash} Trash an experiment. This is reversible and not to be confused with permanent deletion.

\code{experiments.update} Update an experiment.
(all parameters are optional, except for experiment_id)\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}
}
\examples{
\dontrun{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")
}
\dontrun{experiments.clone_full(cyto_session, 22)
}
\dontrun{experiments.clone_selective(cyto_session, 22,
  experiment_name="My New Experiment Name", fcs_files=c(12, 13, 14, 15, 16))
}
\dontrun{experiments.delete(cyto_session, 22)
}
\dontrun{# Dataframe of all full access users
experiments.full_access_users_list(cyto_session, 22)

# List of all full access users
experiments.full_access_users_list(cyto_session, 22, output="raw")
}
\dontrun{# Add a user as a full access user by user's ID
experiments.full_access_users_add(cyto_session, 22, user_id=2)

# Add a user as a full access user by user's email
experiments.full_access_users_add(cyto_session, 22, user_email="sammy_cytometry@cytobank.org")

# Add a user as a full access user by user's username
experiments.full_access_users_add(cyto_session, 22, username="sammy_cytometry")
}
\dontrun{# Remove a user as a full access user by user's ID
experiments.full_access_users_remove(cyto_session, 22, user_id=2)

# Remove a user as a full access user by user's email
experiments.full_access_users_remove(cyto_session, 22, user_email="sammy_cytometry@cytobank.org")

# Remove a user as a full access user by user's username
experiments.full_access_users_remove(cyto_session, 22, username="sammy_cytometry")
}
\dontrun{# Dataframe of all inbox experiments with all fields present
experiments.list(cyto_session)

# Raw list of all inbox experiments with all fields present
experiments.list(cyto_session, output="raw")
}
\dontrun{experiments.new(cyto_session, "My New Experiment Name", "My experiment purpose",
  "An optional comment")
}
\dontrun{experiments.show(cyto_session, 22)
}
\dontrun{experiments.trash(cyto_session, 22)
}
\dontrun{experiments.update(cyto_session, experiment=cyto_experiment)
}
}
