% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panels.R
\docType{methods}
\name{panels}
\alias{panels}
\alias{panels.list,UserSession-method}
\alias{panels.list}
\alias{panels.show,UserSession-method}
\alias{panels.show}
\title{Panel Endpoints}
\usage{
\S4method{panels.list}{UserSession}(UserSession, experiment_id,
  output = "default", timeout = UserSession@short_timeout)

\S4method{panels.show}{UserSession}(UserSession, experiment_id, panel_id,
  output = "default", timeout = UserSession@short_timeout)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{experiment_id}{integer representing an \link[=experiments]{experiment} ID}

\item{output}{character representing the output format \strong{[optional]}\cr
\emph{- panels.list, panels.show : \code{("default", "raw")}}}

\item{timeout}{integer representing the request timeout time in seconds \strong{[optional]}}

\item{panel_id}{integer representing a panel ID}
}
\description{
Interact with panel endpoints. A collection of channels, the markers being studied on them, and the FCS files this applies to form a panel. \href{https://support.cytobank.org/hc/en-us/articles/206148227-Overview-of-working-with-panels-and-channels}{Learn more about panels in Cytobank}.
}
\details{
\code{panels.list} List all panels from an experiment. Outputs a formatted list [default] or raw list with all fields present.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{panels.show} Show panel details from an experiment. Outputs a full list with all fields present, or an IDs/names list (See \link{attachments} examples section for IDs/names list example).\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}
}
\examples{
\donttest{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")
}
\donttest{# Full panel list with all fields present, with a dataframe of channels
panels.list(cyto_session, 22)

# Raw list of all panels with all fields present
panels.list(cyto_session, 22, output="raw")
}
\donttest{# Full panel info with all fields present
panels.show(cyto_session, 22, panel_id=2)
}
}
