% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ternary.R
\name{plotTernary}
\alias{plotTernary}
\alias{plotTernary.default}
\alias{plotTernary.Seurat}
\alias{plotTernary.SingleCellExperiment}
\alias{plotTernary.simMat}
\title{Create ternary plots}
\usage{
plotTernary(x, ...)

\method{plotTernary}{default}(
  x,
  clusterVar,
  vertices,
  features = NULL,
  veloGraph = NULL,
  byCluster = NULL,
  processed = FALSE,
  method = c("euclidean", "cosine", "pearson", "spearman"),
  force = FALSE,
  sigma = 0.08,
  scale = TRUE,
  dotColor = "grey60",
  returnData = FALSE,
  ...
)

\method{plotTernary}{Seurat}(
  x,
  layer = "counts",
  assay = NULL,
  clusterVar = NULL,
  processed = FALSE,
  ...
)

\method{plotTernary}{SingleCellExperiment}(
  x,
  assay.type = "counts",
  clusterVar = NULL,
  processed = FALSE,
  ...
)

\method{plotTernary}{simMat}(
  x,
  title = NULL,
  veloMat = NULL,
  nGrid = 10,
  radius = 0.1,
  dotSize = 0.6,
  dotColor = "grey60",
  labelColors = c("#3B4992FF", "#EE0000FF", "#008B45FF"),
  vertexLabelSize = 5,
  vertexLabelDrift = 0.03,
  axisBreak = 5,
  axisTextShow = TRUE,
  axisTextSize = 4,
  axisTextDrift = 0.02,
  gridLineAlpha = 0.6,
  arrowLinewidth = 0.25,
  arrowAngle = 20,
  arrowLen = 0.2,
  titleSize = 14,
  equilateral = TRUE,
  margin = 0.1,
  ...
)
}
\arguments{
\item{x}{Input data. Can be a \code{matrix} or \code{dgCMatrix} object with
cells as columns, a \code{Seurat} or \code{SingleCellExperiment} object.
"simMat" method takes intermediate values.}

\item{...}{Arguments passed to other methods.}

\item{clusterVar}{A vector/factor assigning the cluster variable to each
column of the matrix object. For "Seurat" method, \code{NULL} (default) for
\code{Idents(x)}, or a variable name in \code{meta.data} slot. For
"SingleCellExperiment" method, \code{NULL} (default) for \code{colLabels(x)},
or a variable name in \code{colData} slot.}

\item{vertices}{Vector of three unique cluster names that will be used for
plotting. Or a named list that groups clusters as three terminal vertices.
There must not be any overlap between groups.}

\item{features}{Valid matrix row subsetting index to select features for
similarity calculation. Default \code{NULL} uses all available features.}

\item{veloGraph}{Cell x cell \code{dgCMatrix} object containing velocity
information. Shows velocity grid-arrow layer when specified. Default
\code{NULL} does not show velocity.}

\item{byCluster}{Default \code{NULL} to generate one plot with all cells.
Set \code{"all"} to split cells in plot by cluster and returns a list of
subplots for each cluster as well as the plot including all cells. Otherwise,
a vector of cluster names to generate a list of subplots for the specified
clusters.}

\item{processed}{Logical. Whether the input matrix is already processed.
\code{TRUE} will bypass internal preprocessing and input matrix will be
directly used for similarity calculation. Default \code{FALSE} and raw count
input is recommended. If missing in call, using \code{slot = "counts"} in
"Seurat" method or using \code{assay.type = "counts"} in
"SingleCellExperiment" method will force this argument to be \code{FALSE} and
others for \code{TRUE}.}

\item{method}{Similarity calculation method. Default \code{"euclidean"}.
Choose from \code{"euclidean"}, \code{"cosine"}, \code{"pearson"},
\code{"spearman"}.}

\item{force}{Whether to force calculate the similarity when more then 500
features are detected, which is generally not recommended. Default
\code{FALSE}.}

\item{sigma}{Gaussian kernel parameter that controls the effect of variance.
Only effective when using a distance metric (i.e. \code{method} is
\code{"euclidian"} or \code{"cosine"}). Larger values tighten the dot
spreading on figure. Default \code{0.08}.}

\item{scale}{Whether to min-max scale the distance matrix by clusters.
Default \code{TRUE}.}

\item{returnData}{Logical. Whether to return similarity and aggregated
velocity data if applicable instead of generating plot. Default \code{FALSE}.}

\item{layer}{For "Seurat" method, which layer of the assay to be used.
Default \code{"counts"}.}

\item{assay}{For "Seurat" method, the specific assay to get data from.
Default \code{NULL} to the default assay.}

\item{assay.type}{For "SingleCellExperiment" methods. Which assay to use for
calculating the similarity. Default \code{"counts"}.}

\item{title}{Title text of the plot. Default \code{NULL}.}

\item{veloMat}{Aggregated velocity matrix. Output of \code{aggrVeloGraph}.}

\item{nGrid}{Number of grids along the bottom side of the equilateral
triangle. Default \code{10}.}

\item{radius}{Arrow length of unit velocity. Lower this when arrows point
outside of the coordinate. Default \code{0.1}.}

\item{dotSize, dotColor}{Dot aesthetics passed to
\code{\link[ggplot2]{geom_point}}. Default \code{0.6} and \code{"grey60"}.}

\item{labelColors}{Colors of the axis lines and vertex labels.
Default \code{c("#3B4992FF", "#EE0000FF", "#008B45FF")} (blue, red and green)}

\item{vertexLabelSize, vertexLabelDrift}{Adjustment on the three vertex text
labels. Drift means the distance that the labels should be moved against the
center of the plot. Default size \code{5}, drifted distance \code{0.03}.}

\item{axisBreak}{Number of breaks to be labeled along axis. Default
\code{5}.}

\item{axisTextShow}{Logical, whether to show axis text. Default \code{TRUE}.}

\item{axisTextSize, axisTextDrift}{Similar to the vertex adjustment applied
to the text label along the axis breaks. Default size \code{4}, drifted
distance \code{0.02}.}

\item{gridLineAlpha}{Transparency of background grid lines. Default
\code{0.6}.}

\item{arrowLinewidth, arrowAngle, arrowLen}{Arrow aesthetics, see Details.}

\item{titleSize}{Size of title text. Default \code{14}.}

\item{equilateral}{Logical, whether to always display the triangle as
equilateral. Default \code{TRUE}.}

\item{margin}{Margin allowed around of the triangle plotting region when
\code{equilateral = TRUE}}
}
\value{
For "simMat" method, a ggplot object. For other methods, a ggplot
object when \code{splitCluster = FALSE}, or a list of ggplot objects when
\code{splitCluster = TRUE}.
}
\description{
Create ternary plots that show similarity between single cells and
selected three terminals in a ternary baricentric coordinate.
}
\details{
\bold{Argument inheritance} - For matrix/dgCMatrix ("default" method), we
first calculate the similarity matrix and obtain a "simMat" object. Then the
"simMat" method is internally called. For data container objects (e.g.
Seurat), we obtain the correct data matrix first and then call the "default"
method. The arguments inherits as the flow described above.

\bold{The calculation of similarity matrix} - The similarity is calculated
either by converting a distance metric ("euclidean" or "cosine") with
Gaussian kernel, or directly computed with correlation metrics ("pearson" or
"spearman"). The centroid of each terminal is obtained first, and the
specified metric from each cell to each terminal is calculated. The
similarity matrix (n cells by v terminals) is lastly normalized to sum to 1
for each cell, so it becomes a baricentric coordinate.

\bold{Arrow aesthetics parameters} - The shape of arrows is controlled by 3
arguments. Considering an arrow as the combination of a line segment and a
triangle, \code{arrowLinewidth} controls the width of the line as well as
the edge line of the triangle; \code{arrowAngle} equals to angle of the
arrow-tip vertex of the triangle devided by 2 (e.g. the triangle is
equilateral when \code{arrowAngle = 20}); \code{arrowLen} controls the
absolute length from the arrow-tip vertex to its opposite edge.
}
\examples{
gene <- selectTopFeatures(rnaRaw, rnaCluster, c("OS", "RE", "CH"))
plotTernary(rnaRaw, rnaCluster, c("OS", "RE", "CH"), gene)
\donttest{
# Seurat example
library(Seurat)
srt <- CreateSeuratObject(rnaRaw)
Idents(srt) <- rnaCluster
gene <- selectTopFeatures(srt, vertices = c("OS", "RE", "CH"))
plotTernary(srt, features = gene, vertices = c("OS", "RE", "CH"))
}
\donttest{
# SingleCellExperiment example
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(counts = rnaRaw))
colLabels(sce) <- rnaCluster
gene <- selectTopFeatures(sce, vertices = c("OS", "RE", "CH"))
plotTernary(sce, features = gene, vertices = c("OS", "RE", "CH"))
}
}
