% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterizedPrior.R
\name{createParameterizedPrior}
\alias{createParameterizedPrior}
\title{Create a Cyclops parameterized prior object}
\usage{
createParameterizedPrior(
  priorType,
  parameterize,
  values,
  useCrossValidation = FALSE,
  forceIntercept = FALSE
)
}
\arguments{
\item{priorType}{Character vector: specifies prior distribution.  See below for options}

\item{parameterize}{Function list: parameterizes location and variance}

\item{values}{Numeric vector: initial parameter values}

\item{useCrossValidation}{Logical: Perform cross-validation to determine \code{parameters}.}

\item{forceIntercept}{Logical: Force intercept coefficient into prior}
}
\value{
A Cyclops prior object of class inheriting from \code{"cyclopsPrior"} and \code{"cyclopsFunctionalPrior"}
for use with \code{fitCyclopsModel}.
}
\description{
\code{createParameterizedPrior} creates a Cyclops prior object for use with \code{\link{fitCyclopsModel}}
in which arbitrary \code{R} functions parameterize the prior location and variance.
}
