% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/for_multiplicative.LC.multi.R
\name{for_multiplicative.LC.multi}
\alias{for_multiplicative.LC.multi}
\title{FUNCTION TO FORECAST MULTIPLICATIVE MULTI-POPULATION MORTALITY MODEL}
\usage{
for_multiplicative.LC.multi(
  fitted.obj,
  nahead,
  ktmethod = c("Arimapdq", "arima010"),
  kt_include.cte = TRUE
)
}
\arguments{
\item{fitted.obj}{object developed using function \code{fit_mutliplicative.LC.multi()}}

\item{nahead}{number of periods ahead to forecast}

\item{ktmethod}{method used to forecast the value of kt Arima(p,d,q) or ARIMA(0,1,0); c("\code{Arimapdq}", "\code{arima010}").}

\item{kt_include.cte}{if you want that kt include constant in the arima process.}
}
\value{
A list with different components of the forecasting process:
\itemize{
\item \code{ax} parameter that captures the average shape of the mortality curve in all considered populations.
\item \code{bx} parameter that explains the age effect x with respect to the general trend \code{kt} in the mortality rates of all considered populations.
\item \code{arimakt} the arima selected for the \code{kt} time series.
\item \code{kt.fitted} obtained values for the tendency behavior captured by \code{kt}.
\item \code{kt.fut} projected values of \code{kt} for the nahead periods ahead.
\item \code{kt.futintervals} arima selected and future values of \code{kt} with the different intervals, lower and upper, 80\\% and 90\\%.
\item \code{Ii} gives an idea of the differences in the pattern of mortality in any region i with respect to Region 1.
\item \code{formula} additive multi-population mortality formula used to fit the mortality rates.
\item \code{qxt.real} real mortality rates.
\item \code{qxt.fitted} fitted mortality rates using the additive multi-population mortality model.
\item \code{logit.qxt.fitted} fitted mortality rates in logit way estimated with the additive multi-population mortality model.
\item \code{qxt.future} future mortality rates estimated with the additive multi-population mortality model.
\item \code{logit.qxt.future} future mortality rates in logit way estimated with the additive multi-population mortality model.
\item \code{nPop} provided number of populations to fit the periods.
}
}
\description{
R function for forecasting multiplicative multi-population mortality model developed by: Russolillo et al (2011).
This model follows the structure of the well-known Lee-Carter model (Lee and Carter, 1992) but including a multiplicative parameter to capture the behavior of each population considered.
This parameter seeks to capture the individual behavior of every population considered.
It should be mentioned that in case that this function is developed for forecasting several populations.
However, in case you only consider one population, the function will forecast the Lee-Carter model for one population.
}
\examples{
#The example takes more than 5 seconds because it includes
#several fitting and forecasting process and hence all
#the process is included in donttest

\donttest{
#First, we present the data that we are going to use
SpainRegions
ages <- c(0, 1, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90)

#Before forecast the future value of the mortality rates for different populations
#we need the object the fitted values of the multiplicative multi-population mortality model.
library(gnm)
multiplicative_Spainmales <- fit_multiplicative.LC.multi(qxt = SpainRegions$qx_male,
                                             periods = c(1991:2020),
                                             ages = c(ages),
                                             nPop = 18,
                                             lxt = SpainRegions$lx_male)
#Once, we have fit the data, it is possible to forecast 10 years ahead
#in this case for the multiplicative multi-population mortality model
fut_multiplicative_Spainmales <- for_multiplicative.LC.multi(
                  fitted.obj = multiplicative_Spainmales,
                  nahead = 10,
                  ktmethod = "Arimapdq",
                  kt_include.cte = TRUE)

#As we mentioned in the details of the function, if we only provide the data
#from one-population the function fit_additive.LC.multi()
#will fit the Lee-Carter model for single populations.
LC_Spainmales <- fit_multiplicative.LC.multi(qxt = SpainNat$qx_male,
                              periods = c(1991:2020),
                              ages = ages,
                              nPop = 1)
#To forecast future values of the single population using LC
fut_LC_Spainmales <- for_multiplicative.LC.multi(fitted.obj = LC_Spainmales,
                                           nahead = 10, ktmethod = "Arimapdq",
                                           kt_include.cte = TRUE)
}
}
\references{
Lee, R.D. & Carter, L.R. (1992).
Modeling and forecasting US mortality.
Journal of the American Statistical Association, 87(419), 659–671.

Russolillo, M., Giordano, G., & Haberman, S. (2011).
Extending the Lee–Carter model: a three-way decomposition.
Scandinavian Actuarial Journal, 2011(2), 96-117.
}
\seealso{
\code{\link{fit_additive.LC.multi}}, \code{\link{fit_multiplicative.LC.multi}},
\code{\link{for_additive.LC.multi}}, \code{\link{multipopulation_cv}},
}
