% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_sb_splsdrcox.R
\name{cv.isb.splsdrcox}
\alias{cv.isb.splsdrcox}
\title{Cross validation cv.isb.splsdrcox}
\usage{
cv.isb.splsdrcox(
  X,
  Y,
  max.ncomp = 8,
  penalty.list = seq(0.1, 0.9, 0.2),
  n_run = 3,
  k_folds = 10,
  x.center = TRUE,
  x.scale = FALSE,
  remove_near_zero_variance = TRUE,
  remove_zero_variance = TRUE,
  toKeep.zv = NULL,
  remove_variance_at_fold_level = FALSE,
  remove_non_significant_models = FALSE,
  remove_non_significant = FALSE,
  alpha = 0.05,
  w_AIC = 0,
  w_c.index = 0,
  w_AUC = 1,
  w_BRIER = 0,
  times = NULL,
  max_time_points = 15,
  MIN_AUC_INCREASE = 0.01,
  MIN_AUC = 0.8,
  MIN_COMP_TO_CHECK = 3,
  pred.attr = "mean",
  pred.method = "cenROC",
  fast_mode = FALSE,
  MIN_EPV = 5,
  returnData = TRUE,
  return_models = FALSE,
  PARALLEL = FALSE,
  verbose = FALSE,
  seed = 123
)
}
\arguments{
\item{X}{Numeric matrix or data.frame. Explanatory variables. Qualitative variables must be
transform into binary variables.}

\item{Y}{Numeric matrix or data.frame. Response variables. Object must have two columns named as
"time" and "event". For event column, accepted values are: 0/1 or FALSE/TRUE for censored and
event observations.}

\item{max.ncomp}{Numeric. Maximum number of PLS components to compute for the cross validation
(default: 8).}

\item{penalty.list}{Numeric vector. Vector of penalty values. Penalty for sPLS-DRCOX. If
penalty = 0 no penalty is applied, when penalty = 1 maximum penalty (no variables are selected)
based on 'plsRcox' penalty. Equal or greater than 1 cannot be selected (default: seq(0.1,0.9,0.2)).}

\item{n_run}{Numeric. Number of runs for cross validation (default: 3).}

\item{k_folds}{Numeric. Number of folds for cross validation (default: 10).}

\item{x.center}{Logical. If x.center = TRUE, X matrix is centered to zero means (default: TRUE).}

\item{x.scale}{Logical. If x.scale = TRUE, X matrix is scaled to unit variances (default: FALSE).}

\item{remove_near_zero_variance}{Logical. If remove_near_zero_variance = TRUE, near zero variance
variables will be removed (default: TRUE).}

\item{remove_zero_variance}{Logical. If remove_zero_variance = TRUE, zero variance variables will
be removed (default: TRUE).}

\item{toKeep.zv}{Character vector. Name of variables in X to not be deleted by (near) zero variance
filtering (default: NULL).}

\item{remove_variance_at_fold_level}{Logical. If remove_variance_at_fold_level = TRUE, (near) zero
variance will be removed at fold level (default: FALSE).}

\item{remove_non_significant_models}{Logical. If remove_non_significant_models = TRUE,
non-significant models are removed before computing the evaluation. A non-significant model is a
model with at least one component/variable with a P-Value higher than the alpha cutoff.}

\item{remove_non_significant}{Logical. If remove_non_significant = TRUE, non-significant
variables/components in final cox model will be removed until all variables are significant by
forward selection (default: FALSE).}

\item{alpha}{Numeric. Numerical values are regarded as significant if they fall below the
threshold (default: 0.05).}

\item{w_AIC}{Numeric. Weight for AIC evaluator. All weights must sum 1 (default: 0).}

\item{w_c.index}{Numeric. Weight for C-Index evaluator. All weights must sum 1 (default: 0).}

\item{w_AUC}{Numeric. Weight for AUC evaluator. All weights must sum 1 (default: 1).}

\item{w_BRIER}{Numeric. Weight for BRIER SCORE evaluator. All weights must sum 1 (default: 0).}

\item{times}{Numeric vector. Time points where the AUC will be evaluated. If NULL, a maximum of
'max_time_points' points will be selected equally distributed (default: NULL).}

\item{max_time_points}{Numeric. Maximum number of time points to use for evaluating the model
(default: 15).}

\item{MIN_AUC_INCREASE}{Numeric. Minimum improvement between different cross validation models to
continue evaluating higher values in the multiple tested parameters. If it is not reached for next
'MIN_COMP_TO_CHECK' models and the minimum 'MIN_AUC' value is reached, the evaluation stops
(default: 0.01).}

\item{MIN_AUC}{Numeric. Minimum AUC desire to reach cross-validation models. If the minimum is
reached, the evaluation could stop if the improvement does not reach an AUC higher than adding
the 'MIN_AUC_INCREASE' value (default: 0.8).}

\item{MIN_COMP_TO_CHECK}{Numeric. Number of penalties/components to evaluate to check if the AUC
improves. If for the next 'MIN_COMP_TO_CHECK' the AUC is not better and the 'MIN_AUC' is meet,
the evaluation could stop (default: 3).}

\item{pred.attr}{Character. Way to evaluate the metric selected. Must be one of the following:
"mean" or "median" (default: "mean").}

\item{pred.method}{Character. AUC evaluation algorithm method for evaluate the model performance.
Must be one of the following: "risksetROC", "survivalROC", "cenROC", "nsROC", "smoothROCtime_C",
"smoothROCtime_I" (default: "cenROC").}

\item{fast_mode}{Logical. If fast_mode = TRUE, for each run, only one fold is evaluated
simultaneously. If fast_mode = FALSE, for each run, all linear predictors are computed for test
observations. Once all have their linear predictors, the evaluation is perform across all the
observations together (default: FALSE).}

\item{MIN_EPV}{Numeric. Minimum number of Events Per Variable (EPV) you want reach for the final
cox model. Used to restrict the number of variables/components can be computed in final cox models.
If the minimum is not meet, the model cannot be computed (default: 5).}

\item{returnData}{Logical. Return original and normalized X and Y matrices (default: TRUE).}

\item{return_models}{Logical. Return all models computed in cross validation (default: FALSE).}

\item{PARALLEL}{Logical. Run the cross validation with multicore option. As many cores as your
total cores - 1 will be used. It could lead to higher RAM consumption (default: FALSE).}

\item{verbose}{Logical. If verbose = TRUE, extra messages could be displayed (default: FALSE).}

\item{seed}{Number. Seed value for performing runs/folds divisions (default: 123).}
}
\value{
Instance of class "Coxmos" and model "sb.splscox". The class contains the following
elements:
\code{X}: List of normalized X data information.
\itemize{
\item \code{(data)}: normalized X matrix
\item \code{(weightings)}: PLS weights
\item \code{(weightings_norm)}: PLS normalize weights
\item \code{(W.star)}: PLS W* vector
\item \code{(scores)}: PLS scores/variates
\item \code{(x.mean)}: mean values for X matrix
\item \code{(x.sd)}: standard deviation for X matrix
}
\code{Y}: List of normalized Y data information.
\itemize{
\item \code{(deviance_residuals)}: deviance residual vector used as Y matrix in the sPLS.
\item \code{(dr.mean)}: mean values for deviance residuals Y matrix
\item \code{(dr.sd)}: standard deviation for deviance residuals Y matrix'
\item \code{(data)}: normalized X matrix
\item \code{(y.mean)}: mean values for Y matrix
\item \code{(y.sd)}: standard deviation for Y matrix'
}
\code{survival_model}: List of survival model information.
\itemize{
\item \code{fit}: coxph object.
\item \code{AIC}: AIC of cox model.
\item \code{BIC}: BIC of cox model.
\item \code{lp}: linear predictors for train data.
\item \code{coef}: Coefficients for cox model.
\item \code{YChapeau}: Y Chapeau residuals.
\item \code{Yresidus}: Y residuals.
}

\code{list_spls_models}: List of sPLS-DRCOX models computed for each block.

\code{n.comp}: Number of components selected.

\code{penalty} Penalty applied.

\code{call}: call function

\code{X_input}: X input matrix

\code{Y_input}: Y input matrix

\code{nzv}: Variables removed by remove_near_zero_variance or remove_zero_variance.

\code{nz_coeffvar}: Variables removed by coefficient variation near zero.

\code{class}: Model class.

\code{time}: time consumed for running the cox analysis.
}
\description{
This function performs cross-validated sparse partial least squares iterative single
block for splsdrcox. The function returns the optimal number of components and the optimal sparsity
penalty value based on cross-validation. The performance could be based on multiple metrics as
Area Under the Curve (AUC), Brier Score or C-Index. Furthermore, the user could establish more
than one metric simultaneously.
}
\details{
The \code{cv.isb.splsdrcox} function performs cross-validation for the integrative single-block sparse
partial least squares deviance residual Cox analysis. Unlike the single-block (SB) approach, the
integrative single-block (ISB) method allows for the consideration of multiple blocks of data,
potentially from different sources or types, to be integrated into a single model. A key distinction
of the ISB approach is its ability to compute and optimize hyperparameters individually for each
block, rather than applying a uniform set of hyperparameters across all blocks. This ensures that
each block's unique characteristics are taken into account, leading to a more tailored and
potentially more accurate model.

Cross-validation is essential for assessing the generalizability of the model and avoiding
overfitting. By partitioning the original dataset into training and test sets multiple times, the
function evaluates the model's performance across different subsets of the data. This iterative
process ensures that the model's performance is robust and not overly reliant on a specific
partition of the data.

The function evaluates a range of hyperparameters, including the number of latent components
(\code{max.ncomp}) and the penalty for variable selection (\code{penalty.list}). For each combination of
hyperparameters, the dataset is divided into training and test sets based on the specified number
of folds (\code{k_folds}). The model is then trained on the training set and its performance is assessed
on the test set. This process is repeated for the specified number of runs (\code{n_run}), providing a
comprehensive evaluation of the model's performance.

Various evaluation metrics, such as AIC, C-Index, Brier Score, and AUC, are computed for each
combination of hyperparameters. These metrics provide insights into the model's accuracy,
discriminative ability, and calibration. The function then identifies the optimal hyperparameters
that yield the best performance based on these metrics.

In summary, the \code{cv.isb.splsdrcox} function offers a robust and integrative approach for
hyperparameter tuning and model evaluation for the sparse partial least squares deviance residual
Cox analysis. By allowing individualized hyperparameter optimization for each block, the ISB
approach ensures a more nuanced and potentially more accurate model compared to the traditional
SB method.
}
\examples{
data("X_multiomic")
data("Y_multiomic")
set.seed(123)
index_train <- caret::createDataPartition(Y_multiomic$event, p = .5, list = FALSE, times = 1)
X_train <- X_multiomic
X_train$mirna <- X_train$mirna[index_train,1:50]
X_train$proteomic <- X_train$proteomic[index_train,1:50]
Y_train <- Y_multiomic[index_train,]
isb.splsdrcox_model <- cv.isb.splsdrcox(X_train, Y_train, max.ncomp = 2, penalty.list = c(0.5),
n_run = 1, k_folds = 2, x.center = TRUE, x.scale = TRUE)
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
