% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renewal_cstr.R
\name{renewalCount}
\alias{renewalCount}
\title{Fit renewal count processes regression models}
\usage{
renewalCount(formula, data, subset, na.action, weights, offset,
  dist = c("weibull", "weibullgam", "custom", "gamma", "gengamma"),
  anc = NULL, convPars = NULL, link = NULL, time = 1,
  control = renewal.control(...), customPars = NULL, seriesPars = NULL,
  weiMethod = NULL, computeHessian = TRUE, standardise = FALSE,
  standardise_scale = 1, model = TRUE, y = TRUE, x = FALSE, ...)
}
\arguments{
\item{formula}{a formula object. If it is a standard formula object, the left
hand side specifies the response variable and the right hand sides
specifies the regression equation for the first parameter of the
conditional distribution. \code{formula} can also be used to specify the
ancilliary regressions, using the operator `|`, see Details.}

\item{data, subset, na.action, }{arguments controlling formula processing via
\code{model.frame}.}

\item{weights}{optional numeric vector of weights.}

\item{offset}{optional numeric vector with an a priori known component to be
included in the linear predictor of the count model. Currently not used.}

\item{dist}{character, built-in distribution to be used as the inter-arrival
time distribution or \code{"custom"} for a user defined distribution, see
Details. Currently the built-in distributions are \code{"weibull"},
\code{"weibullgam"}, \code{"gamma"}, \code{"gengamma"}
(generalized-gamma) and \code{"burr"}.}

\item{anc}{a named list of formulas for ancillary regressions, if any,
otherwise \code{NULL}. The formulas associated with the (exact) parameter
names are used. The left-hand sides of the formulas in \code{anc} are
ignored.}

\item{convPars}{a list of convolution parameters arguments with slots
\code{nsteps}, \code{extrap} and \code{convMethod}, see
\code{dCount_conv_bi}. If NULL, default parameters will be applied.}

\item{link}{named list of character strings specifying the name of the link
functions to be used in the regression. If \code{NULL}, the canonical
link function will be used, i.e, \code{log} if the parameter is supposed
to be positive, identity otherwise.}

\item{time}{numeric, time at which the count is observed; default to unity
(1).}

\item{control}{a list of control arguments specified via
\code{renewal.control}.}

\item{customPars}{list, user inputs if \code{dist = "custom"}, see details.}

\item{seriesPars}{list, series expansion input parameters with slots
\code{terms} (number of terms in the series expansion), \code{iter}
(number of iteration in the accelerated series expansion algorithm) and
\code{eps} (tolerance in the accelerated series expansion algorithm),
Only used if \code{dist = "weibull"} and \code{weiMethod =
c("series_mat", "series_acc")}.}

\item{weiMethod}{character, computation method to be used if \code{dist =
"weibull"} or \code{"weibullgam"}, see \code{dWeibullCount} and
\code{dWeibullgammaCount}.}

\item{computeHessian}{logical, should the hessian (and hence the covariance
matrix) be computed numerically at the fitted values.}

\item{standardise}{logical should the covariates be standardised using
\code{standardize::standardize()} function.}

\item{standardise_scale}{numeric the desired scale for the covariates;
default to 1}

\item{model, y, x}{logicals. If \code{TRUE} the corresponding components of the
fit (model frame, response, model matrix) are returned.}

\item{...}{arguments passed to \code{renewal.control} in the default setup.}
}
\value{
An \code{S3} object of class "renewal", which is a list with
    components including:
    \describe{

    \item{coefficients}{values of the fitted coefficients.}

    \item{residuals}{vector of weighted residuals \eqn{\omega * (observed -
    fitted)}.}

    \item{fitted.values}{vector of fitted means.}

    \item{optim}{data.frame output of \code{optimx}.}

    \item{method}{optimisation algorithm.}

    \item{control}{the control arguments, passed to \code{optimx}.}

    \item{start}{starting values, passed to \code{optimx}.}

    \item{weights}{weights to apply, if any.}

    \item{n}{number of observations (with weights > 0).}

    \item{iterations}{number of iterations in the optimisation algorithm.}

    \item{execTime}{duration of the optimisation.}

    \item{loglik}{log-likelihood of the fitted model.}

    \item{df.residual}{residuals' degrees of freedom for the fitted model.}

    \item{vcoc}{convariance matrix of all coefficients, computed numerically
    from the hessian at the fitted coefficients (if \code{computeHessian} is
    \code{TRUE}).}

    \item{dist}{name of the inter-arrival distribution.}

    \item{link}{list, inverse link function corresponding to each parameter in
    the inter-arrival distribution.}

    \item{converged}{logical, did the optimisation algorithm converge?}

    \item{data}{data used to fit the model.}

    \item{formula}{the original formula.}

    \item{call}{the original function call.}

    \item{anc}{named list of formulas to model regression on ancillary
    parameters.}

    \item{score_fct}{function to compute the vector of scores defined in
    Cameron(2013) equation 2.94.}

    \item{convPars}{convolution inputs used.}

    \item{customPars}{named list, user passed distribution inputs, see
    Details.}

    \item{time}{observed window used, default is 1.0 (see inputs).}

    \item{model}{the full model frame (if \code{model = TRUE}).}

    \item{y}{the response count vector (if \code{y = TRUE}).}

    \item{x}{the model matrix (if \code{x = TRUE}).}
}
}
\description{
Fit renewal regression models for count data via maximum likelihood.
}
\details{
\code{renewal} re-uses design and functionality of the basic R tools for
fitting regression model (\code{lm}, \code{glm}) and is highly inspired by
\code{hurdle()} and \code{zeroinfl()} from package \code{pscl}. Package
\code{Formula} is used to handle formulas.

Argument \code{formula} is a \code{formula} object. In the simplest case its
left-hand side (lhs) designates the response variable and the right-hand side
the covariates for the first parameter of the distribution (as reported by
\code{\link{getParNames}}. In this case, covariates for the ancilliary
parameters are specified using argument \code{anc}.

The ancilliary regressions, can also be specified in argument \code{formula}
by adding them to the righ-hand side, separated by the operator \sQuote{|}.
For example \code{Y | shape ~ x + y | z} can be used in place of the pair
\code{Y ~ x + y} and \code{anc = list(shape = ~z)}. In most cases, the name
of the second parameter can be omitted, which for this example gives the
equivalent \code{Y ~ x + y | z}. The actual rule is that if the parameter is
missing from the left-hand side, it is inferred from the default parameter
list of the distribution.

As another convenience, if the parameters are to to have the same covariates,
it is not necessary to repeat the rhs. For example, \code{Y | shape ~ x + y}
is equivalent to \code{Y | shape ~ x + y | x + y}. Note that this is applied
only to parameters listed on the lhs, so \code{Y ~ x + y} specifies
covariates only for the response variable and not any other parameters.

Distributions for inter-arrival times supported internally by this package
can be chosen by setting argument \code{"dist"} to a suitable character
string.  Currently the built-in distributions are \code{"weibull"},
\code{"weibullgam"}, \code{"gamma"}, \code{"gengamma"} (generalized-gamma)
and \code{"burr"}.

Users can also provide their own inter-arrival distribution.  This is done by
setting argument \code{"dist"} to \code{"custom"}, specifying the initial
values and giving argument \code{customPars} as a list with the following
components:

\describe{

\item{parNames}{character, the names of the parameters of the distribution.
    The location parameter should be the first one.}

\item{survivalFct}{function object containing the survival function. It
    should have signature \code{function(t, distPars)} where \code{t} is the
    point where the survival function is evaluated and \code{distPars} is the
    list of the distribution parameters. It should return a double value.}

\item{extrapolFct}{function object computing the extrapolation values
    (numeric of length 2) from the value of the distribution parameters (in
    \code{distPars}). It should have signature \code{function(distPars)} and
    return a numeric vector of length 2. Only required if the extrapolation
    is set to \code{TRUE} in \code{convPars}.}
}

Some checks are done to validate \code{customPars} but it is user's
responsibility to make sure the the functions have the appropriate
signatures.

\strong{Note:} The Weibull-gamma distribution is an experimental version and
should be used with care! It is very sensitive to initial values and there is no
guarantee of convergence. It has also been reparameterized in terms of
\eqn{(1/r, 1/\alpha, c)}{(1/r, 1/alpha, c)} instead of \eqn{(r, \alpha,
c)}{(r, alpha, c)}, where \eqn{r} and \eqn{\alpha}{alpha} are the shape
and scale of the gamma distribution and \eqn{c} is the shape of the Weibull
distribution.

\strong{(2017-08-04(Georgi) experimental feature:} probability residuals in
component 'probResiduals'. I also added type 'prob' to the method for
residuals() to extract them.

probResiduals[i] is currently 1 - Prob(Y[i] given the
covariates). "one minus", so that values close to zero are "good".  On its
own this is probably not very useful but when comparing two models, if one of
them has mostly smaller values than the other, there is some reason to claim
that the former is superior. For example (see below), gamModel < poisModel in
3:1
}
\references{
\insertRef{cameron2013regression}{Countr}
}
