% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{alphagen}
\alias{alphagen}
\title{Matrix of alpha terms}
\usage{
alphagen(cc, jrow, ncol)
}
\arguments{
\item{cc}{numeric, shape parameter.}

\item{jrow}{numeric, number of rows of the alpha matrix. See formulae (11) in
\emph{McShane(2008)}.}

\item{ncol}{numeric, number of columns of the alpha matrix. Note that the
first column corresponds to \eqn{n=0}, \eqn{n} being the count value, see
formulae (11) in \emph{McShane(2008)}.}
}
\value{
\code{jrow} x \code{ncol} (lower triangular) matrix of
    \eqn{\alpha_j^n} terms defined in \emph{McShane(2008)}.
}
\description{
Matrix of alpha terms used internally by the different Weibull count
functions.
}
\details{
It is usually advisable to compute the alpha terms a minimum number of times
as it may be time consuming in general. Note that the alpha terms only depend
on the shape (c) parameter
}
\examples{
## alphagen(0.994, 6, 8)

}
\keyword{internal}

