% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_policy_scores}
\alias{get_policy_scores}
\title{Download Policy Intensity Scores}
\usage{
get_policy_scores(
  countries = "All",
  type = "All",
  from = "2019-12-31",
  to = "2021-07-01",
  time_out = FALSE
)
}
\arguments{
\item{countries}{Specify a specific country to query By default all countries.}

\item{type}{Specify a specific index to query. By default all types.}

\item{from}{The beginning time period in YYYY-MM-DD format.}

\item{to}{The end time period in YYYY-MM-DD format. At present the index goes until 04-29-2021.}

\item{time_out}{Whether to set a 5-second time-out on the API call. Beyond 5 seconds, the function
will return an empty data-frame. Only useful for complying with CRAN
submission requirements. Default is FALSE.}
}
\value{
A data frame with one row per policy intensity score per country
}
\description{
This function accesses the latest policy intensity scores showing the level of COVID-19 policy-making activity
in a given country with measurement error.
}
\details{
Use this function to access the latest policy intensity scores for six types: ,
\enumerate{
\item Business
\item Health Monitoring
\item Health Resources
\item Masks
\item Schools
\item Social Distancing
}

By default, all six indices for all countries are downloaded, running from the index start at January 1, 2020
until April 29, 2021. The indices are periodically updated with new data as the CoronaNet project continues
coding policies and integrating external datasets.

The scores are Normally-distributed with a mean of 0. It is possible to
re-scale the scores but we recommend using the default scale to preserve
relationships between units and time points.

You can read more about the index construction and evaluation
in \href{https://osf.io/preprints/socarxiv/rn9xk/}{our working paper}.

Citation:

Kubinec, Robert; Barcelo, Joan; Goldzsmidt, Rafael; Grujic, Vanja; Model, Timothy; Schenk, Caress; Cheng, Cindy; Hale, Thomas; Spencer Hartnett, Allison; Messerschmidt, Luca; Petherick, Anna, and Thorvaldsdottir, Svanhildur. "Cross-National Measures of the Intensity of COVID-19 Public Health Policies." SocArchiv (2022). https://osf.io/preprints/socarxiv/rn9xk/

Because the indices were produced with a measurement model, they include measurement error. The most likely
estimate is in the \code{med_estimate} column, and the uncertainty interval high/low are in the
\code{low_estimate}\\code{high_estimate} columns. The \code{SD_estimate} column has the standard deviation of the
measurement error. These measurement error estimates can be used either in a model that explicitly incorporates
the SD of the measurement error (so-called errors-in-variables models) or by using the \code{low_estimate} and
\code{high_estimate} scores as robustness checks. The default for estimation and modeling should be the most likely
\code{med_estimate} column.
}
\examples{
# Download policy intensity scores for Japan and China

japan_scores <- get_policy_scores(countries=c("Japan","China"),
                from="2020-01-01",
                to="2020-01-05",
                 time_out=TRUE)

}
