% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreSetClass.R
\docType{class}
\name{CoreSet-class}
\alias{CoreSet-class}
\alias{.CoreSet}
\alias{cellInfo,CoreSet-method}
\alias{cellInfo<-,CoreSet,data.frame-method}
\alias{phenoInfo,CoreSet-method}
\alias{phenoInfo<-,CoreSet,character,data.frame-method}
\alias{molecularProfiles,CoreSet,character-method}
\alias{molecularProfiles<-,CoreSet,character,matrix-method}
\alias{featureInfo,CoreSet-method}
\alias{featureInfo<-,CoreSet,character,data.frame-method}
\alias{sensitivityInfo,CoreSet-method}
\alias{sensitivityInfo<-,CoreSet,data.frame-method}
\alias{sensitivityProfiles,CoreSet-method}
\alias{sensitivityProfiles<-,CoreSet,data.frame-method}
\alias{sensitivityProfiles<-,CoreSet,matrix-method}
\alias{sensitivityMeasures,CoreSet-method}
\alias{cellNames,CoreSet-method}
\alias{cellNames<-,CoreSet,character-method}
\alias{fNames,CoreSet-method}
\alias{dateCreated,CoreSet-method}
\alias{cSetName,CoreSet-method}
\alias{pertNumber,CoreSet-method}
\alias{sensNumber,CoreSet-method}
\alias{pertNumber<-,CoreSet,array-method}
\alias{sensNumber<-,CoreSet,matrix-method}
\title{A Superclass to Contain Data for Genetic Profiling and Viability Screens of Cancer Cell Lines}
\usage{
\S4method{cellInfo}{CoreSet}(cSet)

\S4method{cellInfo}{CoreSet,data.frame}(object) <- value

\S4method{phenoInfo}{CoreSet}(cSet, mDataType)

\S4method{phenoInfo}{CoreSet,character,data.frame}(object,
  mDataType) <- value

\S4method{molecularProfiles}{CoreSet,character}(cSet, mDataType)

\S4method{molecularProfiles}{CoreSet,character,matrix}(object,
  mDataType) <- value

\S4method{featureInfo}{CoreSet}(cSet, mDataType)

\S4method{featureInfo}{CoreSet,character,data.frame}(object,
  mDataType) <- value

\S4method{sensitivityInfo}{CoreSet}(cSet)

\S4method{sensitivityInfo}{CoreSet,data.frame}(object) <- value

\S4method{sensitivityProfiles}{CoreSet}(cSet)

\S4method{sensitivityProfiles}{CoreSet,data.frame}(object) <- value

\S4method{sensitivityProfiles}{CoreSet,matrix}(object) <- value

\S4method{sensitivityMeasures}{CoreSet}(cSet)

\S4method{cellNames}{CoreSet}(cSet)

\S4method{cellNames}{CoreSet,character}(object) <- value

\S4method{fNames}{CoreSet}(cSet, mDataType)

\S4method{dateCreated}{CoreSet}(cSet)

\S4method{cSetName}{CoreSet}(cSet)

\S4method{pertNumber}{CoreSet}(cSet)

\S4method{sensNumber}{CoreSet}(cSet)

\S4method{pertNumber}{CoreSet,array}(object) <- value

\S4method{sensNumber}{CoreSet,matrix}(object) <- value
}
\arguments{
\item{cSet}{A \code{CoreSet} object}

\item{object}{A \code{CoreSet} object}

\item{value}{A replacement value}

\item{mDataType}{A \code{character} with the type of molecular data to return/update}
}
\value{
An object of the CoreSet class
}
\description{
The CoreSet (CSet) class was developed as a superclass for objects in the 
PharmacoGx and RadioGx packages to contain the data generated in screens 
of cancer cell lines for their genetic profile and sensitivities to therapy
(Pharmacological or Radiation). This class is meant to be a superclass which 
is contained within the PharmacoSet (PSet) and RadioSet (RSet) objects 
exported by PharmacoGx and RadioGx. The format of the data is similar for 
both data PSets and RSets, allowing much of the code to be abstracted into 
the CoreSet super-class. However, the models involved with quantifying 
cellular response to Pharmacological and Radiation therapy are widely 
different, and two seperate implementations of the CSet class allows the
packages to apply the correct model for the given data.
}
\section{Methods (by generic)}{
\itemize{
\item \code{cellInfo}: Returns the annotations for all the cell lines tested on in the CoreSet

\item \code{cellInfo<-}: Update the cell line annotations

\item \code{phenoInfo}: Return the experiment info from the given type of molecular data in CoreSet

\item \code{phenoInfo<-}: Update the the given type of molecular data experiment info in the CoreSet

\item \code{molecularProfiles}: Return the given type of molecular data from the CoreSet

\item \code{molecularProfiles<-}: Update the given type of molecular data from the CoreSet

\item \code{featureInfo}: Return the feature info for the given molecular data

\item \code{featureInfo<-}: Replace the gene info for the molecular data

\item \code{sensitivityInfo}: Return the drug dose sensitivity experiment info

\item \code{sensitivityInfo<-}: Update the sensitivity experiment info

\item \code{sensitivityProfiles}: Return the phenotypic data for the drug dose sensitivity

\item \code{sensitivityProfiles<-}: Update the phenotypic data for the drug dose
sensitivity

\item \code{sensitivityProfiles<-}: Update the phenotypic data for the drug dose
sensitivity

\item \code{sensitivityMeasures}: Returns the available sensitivity profile
summaries, for example, whether there are IC50 values available

\item \code{cellNames}: Return the cell names used in the dataset

\item \code{cellNames<-}: Update the cell names used in the dataset

\item \code{fNames}: Return the feature names used in the dataset

\item \code{dateCreated}: Return the date the CoreSet was created

\item \code{cSetName}: Return the name of the CoreSet

\item \code{pertNumber}: Return the summary of available perturbation
experiments

\item \code{sensNumber}: Return the summary of available sensitivity
experiments

\item \code{pertNumber<-}: Update the summary of available perturbation
experiments

\item \code{sensNumber<-}: Update the summary of available sensitivity
experiments
}}

\section{Slots}{

\describe{
\item{\code{annotation}}{A \code{list} of annotation data about the CoreSet,
including the \code{$name} and the session information for how the object
was creating, detailing the exact versions of R and all the packages used}

\item{\code{molecularProfiles}}{A \code{list} containing 4 \code{Biobase::ExpressionSet} 
type object for holding data for RNA, DNA, SNP and Copy Number Variation 
measurements respectively, with associated \code{fData} and \code{pData} 
containing the row and column metadata}

\item{\code{cell}}{A \code{data.frame} containg the annotations for all the cell 
lines profiled in the data set, across all data types}

\item{\code{sensitivity}}{A \code{list} containing all the data for the sensitivity 
experiments, including \code{$info}, a \code{data.frame} containing the 
experimental info,\code{$raw} a 3D \code{array} containing raw data, 
\code{$profiles}, a \code{data.frame} containing sensitivity profiles 
statistics, and \code{$n}, a \code{data.frame} detailing the number of 
experiments for each cell-drug/radiationInfo pair}

\item{\code{perturbation}}{A \code{list} containting \code{$n}, a \code{data.frame} 
summarizing the available perturbation data,}

\item{\code{curation}}{A \code{list} containing mappings for
\code{cell}, \code{tissue} names  used in the data set to universal 
identifiers used between different CoreSet objects}

\item{\code{datasetType}}{A \code{character} string of 'sensitivity', 
'perturbation', or both detailing what type of data can be found in the 
CoreSet, for proper processing of the data}
}}

