% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deg_simulation.R
\name{make_DEG_data}
\alias{make_DEG_data}
\title{Simulate differentially expressed gene data (Gaussian)}
\usage{
make_DEG_data(
  n.genes,
  n.samples.A,
  n.samples.B,
  exp.mean = 8,
  exp.sd = 2,
  alpha = 0.2,
  size.factor.sd = 0.1,
  ...
)
}
\arguments{
\item{n.genes}{The total number of genes in the simulated data.}

\item{n.samples.A}{The number of samples in the group A.}

\item{n.samples.B}{The number of samples in the group B.}

\item{exp.mean}{The mean of log-normal distribution that determines gene-specific expression mean.}

\item{exp.sd}{The standard deviation of log-normal distribution that determines gene-specific expression means.}

\item{alpha}{The dispersion ratio of gene-specific expression standard deviation to mean.}

\item{size.factor.sd}{The standard deviation of size factors for samples.}

\item{...}{The parameters passed to function \code{\link{make_DEG_pattern}}.}
}
\value{
This function will return a list with the following components:
  \item{DEG}{The matrix of simulated DEG pattern, which is generated by \code{\link{make_DEG_pattern}}.}
  \item{countsA}{The expression matrix of group A. Each row represents a gene and each column represents a sample.}
  \item{countsB}{The expression matrix of group B. Each row represents a gene and each column represents a sample.}
}
\description{
Generate differentially expressed gene (DEG) data from Gaussian distribution.
}
\details{
The expression values of each gene are assumed following a Gaussian distribution with 
gene-specific mean, which follows a log-normal distribution. The size factor for each
sample follows a Gaussian distribution with zero mean and specific standard deviation.
The heterogeneity of gene expression data is simulated by using the function \code{\link{make_DEG_pattern}}.
}
