% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_par_copula.R
\name{rc_par_copula}
\alias{rc_par_copula}
\title{Copula regression models with parametric margins for bivariate right-censored data}
\source{
Tao Sun, Yi Liu, Richard J. Cook, Wei Chen and Ying Ding (2018).
Copula-based Score Test for Bivariate Time-to-event Data, with Application to a Genetic Study of AMD Progression.
\emph{Lifetime Data Analysis} doi:10.1007/s10985-018-09459-5. \cr
Tao Sun and Ying Ding (2019).
Copula-based Semiparametric Transformation Model for Bivariate Data Under General Interval Censoring.
http://arxiv.org/abs/1901.01918.
}
\usage{
rc_par_copula(data, var_list, copula = "Clayton", m.dist = "Weibull",
  n.cons = 4, method = "Newton", iter = 500, stepsize = 1e-06)
}
\arguments{
\item{data}{a data frame; must have id (subject id), ind (1,2 for two margins), obs_time, status (0 for right-censoring, 1 for event).}

\item{var_list}{the list of covariates to be fitted into the model.}

\item{copula}{specify the copula family.}

\item{m.dist}{specify the marginal baseline distribution.}

\item{n.cons}{number of pieces, only for m.dist = "Piecewise". Default is 4.}

\item{method}{optimization method; default is "Newton" (from nlm).}

\item{iter}{number of iterations; default is 500.}

\item{stepsize}{size of optimization step; default is 1e-6.}
}
\value{
a CopulaCenR object summarizing the model. Can be used as an input to general S3 methods including
summary, plot, lines, coef, logLik, predict.
}
\description{
Fits a copula model with parametric margins for bivariate right-censored data.
}
\details{
The supported copula models are "Clayton", "Gumbel", "Frank", "AMH", "Joe", "Copula2".
The "Copula2" model is a two-parameter copula model that incorporates Clayton and Gumbel as special cases.
The supported marginal distributions are "Weibull" (proportional hazards), "Gompertz" (proportional hazards),
"Piecewise" (proportional hazards) and "Loglogistic" (proportional odds).
We assume the same baseline parameters between two margins. \cr

The input data must be a data frame with columns id (subject id), ind (1,2 for two margins; each id must have both ind = 1 and 2), obs_time, status (0 for right-censoring, 1 for event) and covariates. \cr

Optimization methods can be "Newton" (from nlm) and all methods from optim, such as "Nelder-Mead", "BFGS", "CG", "L-BFGS-B", "SANN". "Brent" is not allowed due to more than one estimators.
}
\examples{
# fit a Clayton-Weibull model
data(DRS)
clayton_wb <- rc_par_copula(data = DRS, var_list = "treat",
                            copula = "Clayton",
                            m.dist = "Weibull", method = "Newton",
                            iter = 500, stepsize = 1e-06)
summary(clayton_wb)
}
