% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GamePropertyWeakSuperadditivity.R
\name{isWeaklySuperadditiveGame}
\alias{isWeaklySuperadditiveGame}
\alias{isZeroMonotonicGame}
\alias{isWeaklySuperAdditiveGame}
\title{Check if game is weakly superadditive}
\usage{
isWeaklySuperadditiveGame(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
\code{TRUE} if the game is weakly superadditive, else \code{FALSE}.
}
\description{
Checks if a TU game with n players is weakly superadditive. \cr
Let \code{S} be a coalition and \code{i} a player not contained in \code{S}. 
Then the TU game is weakly superadditive if for any \code{S} and 
any \code{i} the value of the union of \code{S} and \code{i} is
greater or equal the sum of the values of \code{S} and \code{i}. \cr
Note that weak superadditivity is equivalent to zero-monotonicity.
}
\examples{
library(CoopGame)
isWeaklySuperadditiveGame(c(0,0,0,1,1,1,1))

\donttest{
#Example of a weakly superadditive game
library(CoopGame)
v1=c(1:15)
isWeaklySuperadditiveGame(v1)

#Example of a game which is not weakly superadditive
library(CoopGame)
v2=c(1:5,7,7)
isWeaklySuperadditiveGame(v2)
}

}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, p. 10
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
