% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitMatrix.R
\name{getPlayersFromBMRow}
\alias{getPlayersFromBMRow}
\title{Extract players from bit matrix row}
\usage{
getPlayersFromBMRow(bmRow)
}
\arguments{
\item{bmRow}{represents the bit matrix row}
}
\value{
playerVector contains involved players (e.g. c(1,3), see example below for bitIndex=5 and n=3)
}
\description{
getPlayersFromBMRow determines players involved 
in a coalition from the row of a bit matrix
}
\examples{
library(CoopGame)
bm=createBitMatrix(n=3,A=c(0,0,0,1,1,1,2))
getPlayersFromBMRow(bmRow=bm[4,])

\donttest{
library(CoopGame)
bm=createBitMatrix(n=3,A=c(1:7))
#Corresponding bit matrix:
#           cVal
#[1,] 1 0 0    1
#[2,] 0 1 0    2
#[3,] 0 0 1    3
#[4,] 1 1 0    4
#[5,] 1 0 1    5 <=Specified bit index
#[6,] 0 1 1    6
#[7,] 1 1 1    7

#Determine players from bit matrix row by index 5
players=getPlayersFromBMRow(bmRow=bm[5,])
#Result:
players 
#[1] 1 3
}

}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
