% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DictatorGame.R
\name{dictatorGameVector}
\alias{dictatorGameVector}
\title{Compute game vector for a dictator game}
\usage{
dictatorGameVector(n, dictator)
}
\arguments{
\item{n}{represents the number of players}

\item{dictator}{Number of the dictator}
}
\value{
Game vector where each element contains \code{1} if dictator is involved, \code{0} otherwise.
}
\description{
\strong{Game vector for a dictator game:} \cr
For further information see \link{dictatorGame}
}
\examples{
library(CoopGame)
dictatorGameVector(n=3,dictator=2)

}
\references{
Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, p. 295

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, p. 764
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
