% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitMatrix.R
\name{createBitMatrix}
\alias{createBitMatrix}
\title{create bit matrix}
\usage{
createBitMatrix(n, A = NULL)
}
\arguments{
\item{n}{represents the number of players}

\item{A}{Numeric vector of appropriate size}
}
\value{
The return is a bit matrix containing all possible coalitions apart from the empty coalition
}
\description{
createBitMatrix creates a bit matrix with 
(numberOfPlayers+1) columns and (2^numberOfPlayers-1) rows 
which contains all possible 
coalitions (apart from the null coalition) for the set of all players.  
Each player is represented by a column which describes if this player 
is either participating (value 1) or not participating (value 0).
The last column (named cVal) contains the values of each coalition.
Accordingly, each row of the bit matrix expresses a coalition as a subset of all players.
}
\examples{
library(CoopGame)
createBitMatrix(3,c(0,0,0,60,60,60,72))

\donttest{
library(CoopGame)
A=weightedVotingGameVector(n=3,w=c(1,2,3),q=5)
bm=createBitMatrix(3,A)
bm
# Output:
#            cVal
# [1,] 1 0 0    0
# [2,] 0 1 0    0
# [3,] 0 0 1    0
# [4,] 1 1 0    0
# [5,] 1 0 1    0
# [6,] 0 1 1    1
# [7,] 1 1 1    1
}
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
