#'Summary method for S3 object \code{convergence.clubs}
#'
#'@param object an object of class \code{convergence.clubs}.
#'@param ... other parameters to pass to function \code{summary()}.
#'
#'@export


summary.convergence.clubs <- function(object, ...){
    #table with number of regions per club
    summary_table <- as.data.frame(vapply(object,
                                          FUN=function(x) length(x$id),
                                          FUN.VALUE=1) )
    colnames(summary_table) <- ('# of regions')

    anyDivergent <- 1 * ('divergent' %in% names(object))
    cat(sprintf('Number of convergence clubs: %d', length(object)-anyDivergent), '\n',
        sprintf('Number of divergent units: %d', length(object$divergent$id)), '\n',
        '\n',
        sep='')

    print(summary_table)
}
