% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuickCons.R
\name{QuickCons}
\alias{QuickCons}
\title{Quick algorithm to find up to 4 solutions to the consensus ranking problem}
\usage{
QuickCons(X, Wk = NULL, FULL = FALSE, PS = FALSE)
}
\arguments{
\item{X}{A N by M data matrix in which there are N judges and M objects to be judged. Each row is a ranking of the objects which are represented by the columns. Alternatively X can contain the rankings observed only once in the sample. In this case the argument Wk must be used}

\item{Wk}{Optional: the frequency of each ranking in the data}

\item{FULL}{Default FULL=FALSE. If FULL=TRUE, the searching is limited to the space of full rankings.}

\item{PS}{Default PS=FALSE. If PS=TRUE the number of evaluated branches is diplayed}
}
\value{
a "list" containing the following components:
\tabular{lll}{
Consensus \tab  \tab the Consensus Ranking\cr
Tau \tab       \tab averaged TauX rank correlation coefficient\cr
Eltime\tab   \tab Elapsed time in seconds}
}
\description{
The Quick algorithm finds up to 4 solutions. Solutions reached are most of the time optimal solutions.
}
\details{
This function is deprecated and it will be removed in the 
next release of the package. Use function 'consrank' instead.
}
\examples{
data(EMD)
CR=QuickCons(EMD[,1:15],EMD[,16])

}
\references{
Amodio, S., D'Ambrosio, A. and Siciliano, R. (2016). Accurate algorithms for identifying the median ranking when dealing with weak and partial rankings under the Kemeny axiomatic approach. European Journal of Operational Research, 249(2), 667-676.
}
\seealso{
\code{\link{consrank}}
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
\keyword{Quick}
\keyword{algorithm}
